/*
 *
 * Copyright 2017-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;

/**
 * Ein {@link} Task, der laufend eine bestimmte Aufgabe wiederholt.
 *
 * @author Kappich Systemberatung
 */
public abstract class RepeatingTask extends AbstractTask {

	/**
	 * Konstruktor
	 * @param archiveMgr Archivmanager
	 */
	public RepeatingTask(ArchiveManager archiveMgr) {
		super(archiveMgr);
	}

	@Override
	public ArchiveManager getArchMgr() {
		return (ArchiveManager)super.getArchMgr();
	}
	
	@Override
	protected void execute() {
		try {
			while(true) {
				step();
				if(_shouldTerminate) {
					break;
				}
				else if(Thread.interrupted()) {
					_debug.warning("Thread " + getName() + " wurde unterbrochen, ohne dass terminateTask ausgerufen wurde.");
					break;
				}
			}
		}
		catch(InterruptedException e) {
			if(!_shouldTerminate) {
				_debug.warning("Thread " + getName() + " wurde unterbrochen, ohne dass terminateTask ausgerufen wurde.", e);
			}
		}
		finally {
			if(!_shouldTerminate) {
				_debug.warning("Thread " + getName() + " wurde neu gestartet, da er aufgrund einer Exception beendet wurde.");
				// Thread neu starten
				start();
			}
			else {
				cleanUp();
				super.execute();
			}
		}
	}

	/**
	 * Implementiert die beliebige wiederholt auszuführende Aufgabe
	 * @throws InterruptedException Thread unterbrochen
	 */
	public abstract void step() throws InterruptedException;

}
