/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks;

import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.persistence.util.SignalingQueue;
import de.bsvrz.ars.ars.persistence.writer.AsyncSerializableDataset;

/**
 * Task, der online erhaltene Datensätze serialisiert. Dafür erhält der Task {@link AsyncSerializableDataset}-Objekte
 */
public class SerializeTask extends QueueTask<AsyncSerializableDataset> {

	private final SerializeTaskHelper serializeTaskHelper = new SerializeTaskHelper();

	/**
	 * Erstellt einen neuen SerializeTask.
	 *
	 * @param archiveMgr {@link ArchiveManager}
	 * @param queue      Warteschlange
	 */
	public SerializeTask(ArchiveManager archiveMgr, SignalingQueue<AsyncSerializableDataset> queue) {
		super(archiveMgr, queue);
	}

	@Override
	protected void work(AsyncSerializableDataset dataset) {
		serializeTaskHelper.complete(dataset);
	}
}
