/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.mgmt.tasks.base;

/**
 * Zustand eines Tasks
 */
public enum TaskState {

	/**
	 * Initialer Zustand einer Task nach dem Erzeugen.
	 */
	INIT("neu"),

	/**
	 * Zustand einer Task, die momentan bereit für neue Aufgaben ist.
	 */
	IDLE("bereit"),

	/**
	 * Zustand einer Task, die soeben eine neue Aufgabe bekommen hat und sich auf die Bearbeitung vorbereitet.
	 */
	START_WORK("starten"),

	/**
	 * Zustand einer Task, die mit der Bearbeitung einer Aufgabe beschäftigt ist.
	 */
	WORKING("bearbeiten"),

	/**
	 * Zustand einer Task, die mit den abschließenden Arbeiten nach Bearbeitung einer Aufgabe beschäftigt ist.
	 */
	FINISH_WORK("abschließen"),

	/**
	 * Zustand einer Task, die terminiert wurde.
	 */
	TERMINATED("terminiert");

	/**
	 * Name des Zustands, der für Ausgaben etc. verwendet werden soll.
	 */
	private final String _stateName;

	/**
	 * Der Konstruktor wird verwendet, um den in Ausgaben zu verwendenden Namen des Zustands zu übergeben.
	 *
	 * @param stateName Name des Zustands, der für Ausgaben etc. verwendet werden soll.
	 */
	TaskState(final String stateName) {
		_stateName = stateName;
	}

	/**
	 * Liefert den Namen des Zustands zurück.
	 *
	 * @return Name des Zustands.
	 */
	public String getStateName() {
		return _stateName;
	}

	@Override
	public String toString() {
		return name() + "(" + _stateName + ")";
	}
}
