/*
 *
 * Copyright 2005-2008 by beck et al. projects GmbH, Munich
 * Copyright 2009-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.mgmt.tasks.tasklistener;

import de.bsvrz.ars.ars.mgmt.tasks.AbstractTask;
import de.bsvrz.ars.ars.mgmt.tasks.RepeatingTask;

/**
 * Objekte von Klassen, die dieses Interface implementieren, können sich bei jedem Task-Objekt durch {@link RepeatingTask#addTaskStepListener(TaskStepListener)}
 * registrieren.
 *
 * @author beck et al. projects GmbH
 * @author Alexander Schmidt
 * @version $Revision$ / $Date$ / ($Author$)
 */
@FunctionalInterface
public interface TaskStepListener {

	/** Wird von den Task-Subklassen am Ende eines jeden work().Durchlaufs aufgerufen, wenn dieses Interface beim Task registriert ist.
	 * @param whichTask Task, der work aufgerufen hat.
	 */
	void taskStepDone(AbstractTask whichTask);
}
