/*
 *
 * Copyright 2017-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence;

import java.io.File;
import java.nio.file.Path;

/**
 * Diese Klasse bietet den Dateizugriff auf eine Containerdatei. Mit Methoden wie {@link #getContainerHeaderParamAsString(ContainerManagementInformation)}
 * können einzelne Header-Einträge abgefragt werden. Die Methode {@link #iterator()} iteriert über die Containerdaten.
 * <p>
 * Instanzen dieser Klasse müssen nach Verwendung geschlossen werden ({@link AutoCloseable}).
 * <p>
 * Diese Klasse erlaubt den unsynchronisierten nur-lesenden Zugriff auf beliebige Containerdateien und erlaubt damit 
 * das Lesen von Containerdateien außerhalb des Persistenzverzeichnisses und während der 
 * Initialisierung des Archivsystems und auch von externen Tools wie {@link de.bsvrz.ars.ars.repair.ArchiveFileViewer} oder
 * {@link de.bsvrz.ars.ars.repair.ContainerRescue}.
 * <p>
 * Für den synchronisierten Zugriff im Persistenzverzeichnis existiert die Subklasse {@link ContainerFileHandle}.
 * 
 * @author Kappich Systemberatung
 */
public class BasicContainerFileHandle extends StandaloneContainerFileHandle {

	private final ContainerDirectory _location;

	/**
	 * Konstruktor für super()-Aufruf von {@link ContainerFileHandle}, die das _containerFile verspätet initialisiert.
	 * @param location Container-Verzeichnis
	 */
	BasicContainerFileHandle(ContainerDirectory location) {
		_location = location;
	}

	/**
	 * Haupt-Konstruktor 
	 * @param containerFile Zu öffnende Containerdatei
	 * @param location      Container-Verzeichnis
	 * @throws PersistenceException Fehler beim Lesen (Datei korrupt?)
	 */
	public BasicContainerFileHandle(Path containerFile, final IdContainerFileDir location) throws PersistenceException {
		_location = location;
		_containerFile.accessContainerReadOnly(containerFile);
	}

	/**
	 * Gibt den Ort des Containers zurück
	 * @return den Ort des Containers
	 */
	@Override
	public ContainerDirectory getLocation() {
		return _location;
	}

}
