/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence;

public enum RebuildMode {

	Quick("Schnell", true, false),
	Slow("Standard", false, false),
	Full("Voll", false, true),
	FullDelete("FullDelete", true, true);

	private final String name;

	private final boolean delete;
	private final boolean full;

	RebuildMode(String name, boolean delete, boolean full) {
		this.name = name;
		this.delete = delete;
		this.full = full;
	}

	public boolean isDelete() {
		return delete;
	}

	public boolean isFull() {
		return full;
	}

	@Override
	public String toString() {
		return name;
	}
}
