/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.directories.cache;

import javax.xml.crypto.Data;

/**
 * Instanzen dieses Interfaces geben Informationen über den verfügbaren Datenbestand zurück, z. B. in einem Containerdatenverzeichnis
 */
public non-sealed interface ValidDataRange extends DataRange {

	/**
	 * Gibt die minimale Archivzeit zurück
	 *
	 * @return minimale Archivzeit
	 */
	long minArchiveTime();

	/**
	 * Gibt die maximale Archivzeit zurück
	 *
	 * @return maximale Archivzeit
	 */
	long maxArchiveTime();

	/**
	 * Gibt die minimale Datenzeit zurück
	 *
	 * @return minimale Datenzeit
	 */
	long minDataTime();

	/**
	 * Gibt die maximale Datenzeit zurück
	 *
	 * @return maximale Datenzeit
	 */
	long maxDataTime();

	/**
	 * Gibt den minimalen Datenindex zurück
	 *
	 * @return minimaler Datenindex
	 */
	long minDataIndex();

	/**
	 * Gibt den maximalen Datenindex zurück
	 *
	 * @return maximalen Datenindex
	 */
	long maxDataIndex();
}
