/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.index.result;

import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.index.backend.management.IndexContentDescriptor;

import java.util.List;

/**
 * {@link IndexResult}-Wrapper, das zusätzlich zu den Ergebnisdaten des Indexes das zugehörige
 * Wochenverzeichnis speichert.
 */
class BasicLocatedIndexResult<E extends Enum<E>> implements LocatedIndexResult<E> {
	private final IndexResult<E> _indexResult;
	private final PersistenceDirectory _dir;

	/**
	 * Erstellt ein neues BasicLocatedIndexResult.
	 *
	 * @param indexResult Index-Abfrage-Ergebnis
	 * @param dir         Persistenzverzeichnis
	 */
	public BasicLocatedIndexResult(IndexResult<E> indexResult, PersistenceDirectory dir) {
		_indexResult = indexResult;
		_dir = dir;
	}

	@Override
	public int size() {
		return _indexResult.size();
	}

	@Override
	public long get(int index, E value) {
		return _indexResult.get(index, value);
	}

	@Override
	public int getSignedInt(int index, E value) {
		return _indexResult.getSignedInt(index, value);
	}

	@Override
	public String getString(int index, E value) {
		return _indexResult.getString(index, value);
	}

	@Override
	public boolean getBoolean(int index, E value) {
		return _indexResult.getBoolean(index, value);
	}

	@Override
	public boolean hasNext() {
		return _indexResult.hasNext();
	}

	@Override
	public long getNext(E value) {
		return _indexResult.getNext(value);
	}

	@Override
	public boolean isEmpty() {
		return _indexResult.isEmpty();
	}

	@Override
	public long getMin(E value) {
		return _indexResult.getMin(value);
	}

	@Override
	public long getMax(E value) {
		return _indexResult.getMax(value);
	}

	@Override
	public List<IndexContentDescriptor.IndexColumn> getColumns() {
		return _indexResult.getColumns();
	}

	@Override
	public String toString() {
		return _indexResult.toString();
	}

	@Override
	public PersistenceDirectory getPersistenceDirectory(int index) {
		return _dir;
	}

	@Override
	public PersistenceDirectory getNextPersistenceDirectory() {
		return _dir;
	}
}
