/*
 *
 * Copyright 2017-2019 by Kappich Systemberatung, Aachen
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */

package de.bsvrz.ars.ars.persistence.iter;

import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;

import java.util.NoSuchElementException;

/**
 * Eine leerer {@link DataIterator} (Singleton-Implementierung)
 *
 * @see #getInstance()
 *
 * @author Kappich Systemberatung
 */
public class EmptyDataIterator implements DataIterator {
	private static final EmptyDataIterator ourInstance = new EmptyDataIterator();

	/**
	 * Gibt die Instanz zurück
	 * @return die Instanz
	 */
	public static EmptyDataIterator getInstance() {
		return ourInstance;
	}

	/**
	 * Privater Konstruktor
	 */
	private EmptyDataIterator() {
	}

	@Override
	public void peek(final ContainerDataResult result) {
		throw new NoSuchElementException();
	}

	@Override
	public ContainerDataResult peekNext() {
		return null;
	}

	@Override
	public long peekDataIndex() {
		throw new NoSuchElementException();
	}

	@Override
	public long peekDataTime() {
		throw new NoSuchElementException();
	}

	@Override
	public long peekArchiveTime() {
		throw new NoSuchElementException();
	}

	@Override
	public void remove() {
		throw new NoSuchElementException();
	}

	@Override
	public boolean isEmpty() {
		return true;
	}

	@Override
	public void close() {
	}

	@NotNull
	@Override
	public ContainerFileHandle getContainerManagementData() {
		throw new NoSuchElementException();
	}
}
