/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.sequence;

import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.dav.daf.main.archive.ArchiveTimeSpecification;

/**
 * Spezifikation für eine Sequenz von Archivdaten. Entspricht etwa intern einer {@link ArchiveTimeSequenceSpecification},
 * unterstützt aber keine Relativ-Anfragen oder Datenzeiten.
 * <p>
 * Diese Klasse definierten einen protokollmäßigen Datenbereich, der monoton ansteigende Datenindexe
 * und/oder Archivzeitstempel besitzt.
 * <p>
 * Instanzen der implementierenden Klassen können aus einer {@link ArchiveTimeSequenceSpecification} typischerweise
 * mit {@link de.bsvrz.ars.ars.persistence.PersistenceManager#createSequenceFromArchiveTimeSpecification(ArchiveTimeSpecification, LockedContainerDirectory)}
 * erstellt werden. Relative Anfragen werden dort jedoch auch nicht unterstützt, diese werden von der Klasse
 * {@link de.bsvrz.ars.ars.persistence.iter.QueryDataSequence} bei Bedarf vorher aufgelöst.
 */
public sealed interface SequenceSpecification permits DataIndexSequenceSpecification, ArchiveTimeSequenceSpecification, AllDataSpecification {
}
