/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.writer;

import de.bsvrz.dav.daf.communication.dataRepresentation.data.byteArray.ByteArrayData;
import de.bsvrz.dav.daf.main.Data;

import java.util.function.Consumer;

public sealed interface ArchiveJob extends Consumer<ArchiveTask> permits ArchiveOnlineData, ArchiveRequestedData, CloseContainerObject, RequestedDataFinished {

	long estimateMemoryUsage();

	static int estimateDataUsage(Data data) {
		if (data == null) {
			return 0;
		}
		if (data instanceof ByteArrayData byteArrayData) {
			return 44 + 8 + byteArrayData.getBytes().length;
		}
		return 32;
	}

	static long estimateDatasetUsage(AsyncSerializableDataset data) {
		long size = 54; // dataset
		Data d = data.originalData();
		if (d != null) {
			size += estimateDataUsage(d);
		}
		return size;
	}

}
