/*
 * Copyright 2023 by DTV-Verkehrsconsult, Aachen
 *
 * This file is part of de.bsvrz.ars.ars.
 *
 * de.bsvrz.ars.ars is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * de.bsvrz.ars.ars is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with de.bsvrz.ars.ars.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Contact Information:
 * DTV-Verkehrsconsult GmbH
 * Pascalstraße 53
 * 52076 Aachen, Germany
 * phone: +49 2408 7047 0
 * mail: <info@dtv-verkehrsconsult.de>
 */
package de.bsvrz.ars.ars.persistence.writer;

/**
 * {@link ArchiveJob}-Implementierung, die vom {@link ArchiveTask} abgearbeitet wird und nach dem Archivieren
 * von allen nachgeforderten Daten dem {@link de.bsvrz.ars.ars.mgmt.tasks.RequestGapTask} mitteilt,
 * dass alle Daten archiviert wurden. daraufhin kann der {@link de.bsvrz.ars.ars.mgmt.tasks.RequestGapTask}
 * bei Bedarf diw nächste Datenlücke anfordern.
 */
public record RequestedDataFinished() implements ArchiveJob {

	@Override
	public long estimateMemoryUsage() {
		return 0;
	}

	@Override
	public void accept(ArchiveTask archiveTask) {
		archiveTask.getArchMgr().getInQueuesMgr().getBackgroundTaskManager().getRequestGapTask().signalNotification();
	}
}
