/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.migration.kappich;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.migration.kappich.MigrateWorker;
import de.bsvrz.ars.persistence.FileSystemPersistenceModule;
import de.bsvrz.dav.daf.main.impl.archive.PersistentContainerStreamSupplier;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.nio.file.Path;
import java.time.Instant;

public class Migrate {
    public static void main(String[] args) {
        try {
            Migrate.runWithArgs(args);
        }
        catch (IllegalArgumentException e) {
            System.err.println();
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (PersistenceException e) {
            System.err.println("Bei der Migration trat ein Fehler in der Persistenzschicht auf:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bei der Migration trat ein Fehler auf:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    public static void runWithArgs(String[] args) throws PersistenceException {
        ArgumentList argumentList = new ArgumentList(args);
        Path src = argumentList.fetchArgument("-src").asPath();
        Path dest = argumentList.fetchArgument("-dst").asPath();
        Instant from = argumentList.hasArgument("-from") ? argumentList.fetchArgument("-from").asInstant() : Instant.MIN;
        Instant to = argumentList.hasArgument("-to") ? argumentList.fetchArgument("-to").asInstant() : Instant.MAX;
        int threads = argumentList.fetchArgument("-threads=4").intValue();
        boolean closeIndexes = argumentList.fetchArgument("-closeIndexes=false").booleanValue();
        Debug.init((String)"Migration", (ArgumentList)argumentList);
        FileSystemPersistenceModule containerLoader = new FileSystemPersistenceModule(src);
        argumentList.ensureAllArgumentsUsed();
        PersistentContainerStreamSupplier allContainers = containerLoader.getAllContainers();
        MigrateWorker worker = new MigrateWorker(allContainers, dest, threads, (Range<Instant>)Range.closedOpen((Comparable)from, (Comparable)to), closeIndexes);
        worker.start();
    }
}

