/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.migration.kappich;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.IdContainerFileDir;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.OpenContainerData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.RestorePersDirTsk;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.StartupProperties;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.LockFileManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.Week;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.ars.ars.persistence.writer.SerializationHelper;
import de.bsvrz.ars.migration.kappich.MigrationKey;
import de.bsvrz.ars.persistence.Container;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.dav.daf.main.impl.archive.ArchiveDataCompression;
import de.bsvrz.dav.daf.main.impl.archive.DataTiming;
import de.bsvrz.dav.daf.main.impl.archive.PersistentContainerData;
import de.bsvrz.dav.daf.main.impl.archive.PersistentContainerStreamSupplier;
import de.bsvrz.dav.daf.main.impl.archive.PersistentData;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class MigrateWorker
implements ContainerCreator {
    private static final Debug _debug = Debug.getLogger();
    private final PersistentContainerStreamSupplier src;
    private final Path target;
    private final AtomicLong containerIdCounter = new AtomicLong();
    private final AtomicLong lastATime = new AtomicLong();
    private final WeekDomain domain;
    private final ConcurrentHashMap<Path, ActivePersistenceDirectory> pathCache = new ConcurrentHashMap();
    private final ContainerSettings.CloseCondition closeConditions;
    private final ThreadLocal<SerializationHelper> serializationHelper;
    private final int numThreads;
    private final Range<Instant> archiveTimeRange;
    private final LockFileManager lockFileManager;
    private final Map<IdContainerFileDir, DataIdentificationMigration> didWorkers = new HashMap<IdContainerFileDir, DataIdentificationMigration>();
    private final boolean closeIndexes;

    public MigrateWorker(PersistentContainerStreamSupplier streamSupplier, Path target, int numThreads, Range<Instant> archiveTimeRange, boolean closeIndexes) {
        this.src = streamSupplier;
        this.target = target;
        this.numThreads = numThreads;
        this.archiveTimeRange = archiveTimeRange;
        this.closeIndexes = closeIndexes;
        this.domain = new WeekDomain();
        this.lockFileManager = new LockFileManager();
        CacheManager.getInstance().setCacheEnabled(false);
        if (Files.exists(target, new LinkOption[0]) && !this.isEmpty(target)) {
            throw new IllegalArgumentException("Zielverzeichnis existiert bereits: " + String.valueOf(target));
        }
        this.closeConditions = new ContainerSettings.CloseCondition();
        this.closeConditions.maxContTime = 1000000L;
        this.closeConditions.maxContSize = 50000000;
        this.closeConditions.maxContAnzDS = 100000;
        this.serializationHelper = ThreadLocal.withInitial(() -> new SerializationHelper(atg -> this.closeConditions, (ContainerCreator)this, false));
    }

    public boolean isEmpty(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    boolean bl2 = bl = !stream.iterator().hasNext();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public void start() throws PersistenceException {
        this.migrateData();
        this.closeDirectories();
        this.writeStartupProperties();
    }

    private void migrateData() {
        while (true) {
            try {
                Container container;
                while ((container = (Container)this.src.fetchNextContainer()) != null) {
                    IdContainerFileDir containerFileDir = container.getContainerIdentification();
                    this.didWorkers.computeIfAbsent(containerFileDir, x$0 -> new DataIdentificationMigration((IdContainerFileDir)x$0)).handleContainer(container);
                }
            }
            catch (Exception e) {
                _debug.error("Ein Container konnte nicht gelesen werden und wird ignoriert", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void writeStartupProperties() throws PersistenceException {
        StartupProperties startupProperties = new StartupProperties(this.target);
        startupProperties.setVal(StartupProperties.STUP_MAX_CONT_ID, this.containerIdCounter.get());
        startupProperties.setVal(StartupProperties.STUP_LAST_ATIME, this.lastATime.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDirectories() throws PersistenceException {
        ArrayList<ActivePersistenceDirectory> directories = new ArrayList<ActivePersistenceDirectory>(this.pathCache.values());
        directories.sort(Comparator.comparing(it -> this.domain.ofPath(this.target.relativize(it.getBasePath()))));
        int count = directories.size();
        _debug.info("Schlie\u00dfe " + count + " Verzeichnisse ab.");
        Instant start = Instant.now();
        int finished = 0;
        StatusPrinter statusPrinter = new StatusPrinter();
        for (ActivePersistenceDirectory value : directories) {
            _debug.info(statusPrinter.getStatusMessage("Verzeichnisse abschlie\u00dfen", Duration.between(start, Instant.now()), StatusPrinter.ApproximationType.Exact, (long)count, (long)finished, 0L) + "\nAktuelles Verzeichnis: " + String.valueOf(value));
            try {
                if (this.closeIndexes) {
                    RestorePersDirTsk.RestoreWorker worker = new RestorePersDirTsk.RestoreWorker("Indexe erzeugen", RebuildMode.Full, (DataIdentificationManager)this, this.numThreads);
                    worker.doRestore((PersistenceDirectory)value);
                }
                value.closePermanently();
                Path basePath = value.getBasePath();
                this.lockFileManager.close(basePath);
                MigrateWorker.deleteDirectoryIfEmpty(basePath);
            }
            catch (InterruptedException e) {
                _debug.warning("Unterbrochen", (Throwable)e);
                return;
            }
            catch (IOException e) {
                _debug.warning("Lock-Datei konnte nicht gel\u00f6scht werden", (Throwable)e);
            }
            finally {
                value.getIndexTree().closeIndexes();
            }
            ++finished;
        }
    }

    private static void deleteDirectoryIfEmpty(Path path) {
        try {
            try (Stream<Path> stream = Files.list(path);){
                if (stream.iterator().hasNext()) {
                    return;
                }
            }
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private SyncKey<IdDataIdentification> getLock(IdDataIdentification dataIdentification) {
        return new MigrationKey(dataIdentification, key -> {
            for (ActivePersistenceDirectory value : this.pathCache.values()) {
                value.getIndexTree().closeIndexes();
            }
        });
    }

    public long nextContainerID() {
        return this.containerIdCounter.incrementAndGet();
    }

    public SyncKey<IdDataIdentification> lockIndex(IdDataIdentification dataIdentification) {
        return this.getLock(dataIdentification);
    }

    public DataIdentTree getDataIdentTree() {
        return null;
    }

    @NotNull
    private ActivePersistenceDirectory createPersistenceDirectory(Path targetDir) throws UncheckedIOException {
        try {
            this.lockFileManager.createWritable(targetDir);
            return new ActivePersistenceDirectory((ContainerCreator)this, ShortPersistenceDirectoryLayout.Instance.createInstance(targetDir, 0));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class DataIdentificationMigration {
        private final IdContainerFileDir containerFileDir;
        private ActivePersistenceDirectory prevDirectory;
        private Week prevTimeRange;
        final Deflater deflater = new Deflater();
        final Inflater inflater = new Inflater();
        final byte[] writeBuf = new byte[4096];

        static byte[] getBuf(byte[] defaultBuffer, int desiredSize) {
            return desiredSize <= defaultBuffer.length ? defaultBuffer : new byte[desiredSize];
        }

        public DataIdentificationMigration(IdContainerFileDir containerFileDir) {
            this.containerFileDir = containerFileDir;
        }

        public void handleContainer(Container container) throws Exception {
            if (this.containerFileDir.getSimVariant() != 0) {
                return;
            }
            SyncKey<IdDataIdentification> lock = MigrateWorker.this.getLock(this.containerFileDir.dataIdentification());
            ArchiveDataKind adk = this.containerFileDir.archiveDataKind();
            LockedContainerDirectory containerDirectory = new LockedContainerDirectory(lock, adk);
            this.handleContainer(containerDirectory, container);
        }

        private void handleContainer(LockedContainerDirectory directory, Container container) throws Exception {
            ContainerDataResult tmp = new ContainerDataResult();
            try (Container.ContainerDataSupplier supplier = container.getSupplier();){
                PersistentData data;
                while ((data = supplier.fetchNextData()) != null) {
                    this.migrateSingleData(data, tmp);
                    if (!MigrateWorker.this.archiveTimeRange.contains((Comparable)Instant.ofEpochMilli(tmp.getArchiveTime()))) {
                        return;
                    }
                    this.writeToOutput(tmp, (ContainerDirectory)directory, this.updateOutDir(tmp.getArchiveTime()));
                }
            }
        }

        private void migrateSingleData(PersistentData data, ContainerDataResult result) throws DataFormatException {
            PersistentContainerData containerData = data.getData();
            byte[] byteData = containerData.getDataBytes();
            result.setDataState(containerData.getDataType());
            result.setDataKind(this.containerFileDir.archiveDataKind());
            DataTiming timing = containerData.getTiming();
            result.setDataIndex(timing.getDataIndex());
            result.setDataTime(timing.getDataTime());
            result.setArchiveTime(timing.getArchiveTime());
            result.setData(null);
            if (byteData != null) {
                byte[] dest = DataIdentificationMigration.getBuf(this.writeBuf, byteData.length);
                if (containerData.getCompression() == ArchiveDataCompression.ZIP) {
                    this.inflater.reset();
                    this.inflater.setInput(byteData);
                    int uncompressedSize = this.inflater.inflate(dest);
                    if (this.inflater.finished()) {
                        byteData = new byte[uncompressedSize];
                        System.arraycopy(dest, 0, byteData, 0, uncompressedSize);
                    } else {
                        ByteArrayOutputStream unzippedData = new ByteArrayOutputStream(byteData.length * 2);
                        unzippedData.write(dest, 0, uncompressedSize);
                        byte[] buffer = new byte[1024];
                        while (!this.inflater.finished()) {
                            int count = this.inflater.inflate(buffer);
                            unzippedData.write(buffer, 0, count);
                        }
                        byteData = unzippedData.toByteArray();
                    }
                } else if (containerData.getCompression() != ArchiveDataCompression.NONE) {
                    throw new RuntimeException("Entpacken von Datens\u00e4tzen nicht m\u00f6glich, da die Version des Packers nicht unterst\u00fctzt wird");
                }
                if (byteData.length > ContainerFile.MAX_UNCOMPRESSED) {
                    this.deflater.reset();
                    this.deflater.setInput(byteData);
                    this.deflater.finish();
                    int compressedDataLength = this.deflater.deflate(dest);
                    if (compressedDataLength < byteData.length && this.deflater.finished()) {
                        result.setData(Arrays.copyOf(dest, compressedDataLength));
                        result.setDataUncompressedSize(byteData.length);
                        result.setDataSize(compressedDataLength);
                        result.setCompressed(true);
                        return;
                    }
                }
                result.setData(byteData);
                result.setDataSize(byteData.length);
                result.setDataUncompressedSize(0);
                result.setCompressed(false);
            }
        }

        private void writeToOutput(ContainerDataResult result, ContainerDirectory location, ActivePersistenceDirectory persistenceDirectory) throws IndexException, SynchronizationFailedException, PersistenceException {
            MigrateWorker.this.lastATime.accumulateAndGet(result.getArchiveTime(), Math::max);
            SerializableDataset dataset = SerializableDataset.create((ContainerDataResult)result);
            MigrateWorker.this.serializationHelper.get().writeData(dataset, persistenceDirectory, location);
        }

        private ActivePersistenceDirectory updateOutDir(long archiveTime) throws PersistenceException {
            Week timeRange = MigrateWorker.this.domain.ofEpochMillis(archiveTime);
            if (timeRange.equals((Object)this.prevTimeRange)) {
                return this.prevDirectory;
            }
            if (this.prevDirectory != null) {
                for (ArchiveDataKind archiveDataKind : ArchiveDataKindCombination.all()) {
                    LockedContainerDirectory containerDirectory = new LockedContainerDirectory(MigrateWorker.this.getLock(this.containerFileDir.dataIdentification()), archiveDataKind);
                    this.closeOpenContainer(containerDirectory);
                }
            }
            this.prevTimeRange = timeRange;
            Path targetDir = MigrateWorker.this.target.resolve(MigrateWorker.this.domain.getPath(timeRange));
            this.prevDirectory = MigrateWorker.this.pathCache.computeIfAbsent(targetDir, path -> MigrateWorker.this.createPersistenceDirectory(targetDir));
            return this.prevDirectory;
        }

        private void closeOpenContainer(LockedContainerDirectory containerDirectory) throws PersistenceException {
            OpenContainerData openContainerData = this.prevDirectory.getLoadedContainerData((ContainerDirectory)containerDirectory);
            if (openContainerData instanceof StandardOpenContainerData) {
                StandardOpenContainerData containerData = (StandardOpenContainerData)openContainerData;
                try (ContainerFileHandle containerFileHandle = this.prevDirectory.accessOpenContainer((ContainerDirectory)containerDirectory, containerData.getContainerId());){
                    ContainerFile cf = containerFileHandle.getContainerFile();
                    cf.closeContainer(containerData);
                    this.prevDirectory.removeOpenContainerData((ContainerDirectory)containerDirectory);
                }
            }
        }
    }
}

