/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.persistence;

import de.bsvrz.ars.persistence.Container;
import de.bsvrz.ars.persistence.FileSystemPersistenceModule;
import de.bsvrz.dav.daf.main.impl.archive.PersistentContainerStreamSupplier;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.stream.Stream;

public class PersistentContainerSupplier
implements PersistentContainerStreamSupplier {
    private final LinkedList<Path> _openList = new LinkedList();
    private final FileSystemPersistenceModule _containerLoader;
    private long _lastContainerId = -1L;
    private static final Debug _debug = Debug.getLogger();
    private boolean _cancel = false;

    public PersistentContainerSupplier(Path rootFolder, FileSystemPersistenceModule containerLoader) {
        this._openList.add(rootFolder);
        this._containerLoader = containerLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Container fetchNextContainer() throws IOException {
        LinkedList<Path> linkedList = this._openList;
        synchronized (linkedList) {
            if (this._cancel) {
                throw new IllegalStateException("Es wurde bereits cancel aufgerufen ");
            }
            while (!this._openList.isEmpty()) {
                Path currentNode = this._openList.removeFirst();
                if (currentNode.getFileName().toString().endsWith(".arsaw")) {
                    return this.loadContainer(currentNode);
                }
                Comparator fileComparator = (file1, file2) -> {
                    String a = file1.getFileName().toString();
                    String b = file2.getFileName().toString();
                    if (a.endsWith(".arsaw") && b.endsWith(".arsaw")) {
                        Long ContainerId1Long1 = Long.parseLong(a.split("[.]")[0]);
                        Long ContainerId1Long2 = Long.parseLong(b.split("[.]")[0]);
                        return ContainerId1Long1.compareTo(ContainerId1Long2);
                    }
                    if (a.contains("-") && b.contains("-")) {
                        Long ContainerId1Long1 = Long.parseLong(a.split("-")[0]);
                        Long ContainerId1Long2 = Long.parseLong(b.split("-")[0]);
                        return ContainerId1Long1.compareTo(ContainerId1Long2);
                    }
                    return a.contains("-") ? -1 : 1;
                };
                Stream<Path> pathStream = Files.list(currentNode);
                try {
                    pathStream.filter(this::isArchiveFileOrDirectory).sorted(fileComparator.reversed()).forEachOrdered(this._openList::addFirst);
                }
                finally {
                    if (pathStream == null) continue;
                    pathStream.close();
                }
            }
            return null;
        }
    }

    private boolean isArchiveFileOrDirectory(Path it) {
        if (Files.isRegularFile(it, new LinkOption[0]) && it.getFileName().toString().endsWith(".arsaw")) {
            return true;
        }
        if (it.getFileName().toString().matches("\\d+-\\d+")) {
            return true;
        }
        _debug.warning("Datei " + String.valueOf(it) + " ist keine bekannte Archivdatei und wird ignoriert.");
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        LinkedList<Path> linkedList = this._openList;
        synchronized (linkedList) {
            this._openList.clear();
            this._cancel = true;
        }
    }

    private Container loadContainer(Path containerFile) throws IOException {
        long containerId = Long.parseLong(containerFile.getFileName().toString().split("[.]")[0]);
        assert (containerId > this._lastContainerId) : "Neue Container ID " + containerId + " letzte ContainerID " + this._lastContainerId;
        this._lastContainerId = containerId;
        try {
            return this._containerLoader.getContainer(containerId);
        }
        catch (IOException e) {
            throw new IOException("Die Datei " + String.valueOf(containerFile) + " konnte nicht ge\u00f6ffnet werden.", e);
        }
    }
}

