/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.backup;

import de.bsvrz.ars.ars.backup.BackupAdapter;
import de.bsvrz.ars.ars.backup.BackupException;
import de.bsvrz.ars.ars.backup.BackupImplementation;
import de.bsvrz.ars.ars.backup.BackupModul;
import de.bsvrz.ars.ars.backup.BackupModule;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Properties;

public class BackupInitializer {
    public static BackupImplementation getBackupModul(String propertiesFile) throws BackupException {
        Object instance;
        Class<?> backupClass;
        if (propertiesFile == null || propertiesFile.isEmpty()) {
            return null;
        }
        Properties properties = new Properties();
        try (FileInputStream fis = new FileInputStream(new File(propertiesFile));){
            properties.load(fis);
        }
        catch (IOException ioe) {
            throw new BackupException("Fehler beim Einlesen der BackupProperties-Datei: ", ioe);
        }
        String moduleName = properties.getProperty("backupModul");
        if (moduleName == null || moduleName.isEmpty()) {
            throw new BackupException("Die BackupProperties-Datei '" + propertiesFile + "' enth\u00e4lt keinen Eintrag 'backupModul'");
        }
        try {
            backupClass = Class.forName(moduleName);
        }
        catch (ClassNotFoundException e) {
            throw new BackupException("Das BackupModul '" + moduleName + "' konnte nicht gefunden werden. ", e);
        }
        try {
            instance = backupClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new BackupException("Das BackupModul '" + moduleName + "' konnte nicht instantiiert werden. ", e);
        }
        try {
            return BackupInitializer.initializeBackupModule(properties, instance);
        }
        catch (Exception e) {
            throw new BackupException("Das BackupModul '" + moduleName + "' konnte nicht initialisiert werden. ", e);
        }
    }

    private static BackupImplementation initializeBackupModule(Properties properties, Object instance) throws Exception {
        if (instance instanceof BackupModule) {
            BackupModule backupModule = (BackupModule)instance;
            return backupModule.getInstance(properties);
        }
        if (instance instanceof BackupModul) {
            BackupModul backupModul = (BackupModul)instance;
            backupModul.initialize(properties);
            return new BackupAdapter(backupModul);
        }
        throw new BackupException("Das BackupModul ist nicht vom korrekten Typ de.bsvrz.ars.ars.backup.BackupModule oder de.bsvrz.ars.ars.backup.BackupModul: " + String.valueOf(instance.getClass()));
    }
}

