/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.ars.backup.plugins;

import de.bsvrz.ars.ars.backup.plugins.AbstractFileSystemBackup;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import java.io.File;
import java.util.Properties;

public class FileSystemBackupImpl
extends AbstractFileSystemBackup {
    public FileSystemBackupImpl(Properties props) {
        String zipSize = props.getProperty("containerPerZip");
        try {
            if (zipSize != null) {
                this._maxContainersPerZip = Integer.parseInt(zipSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String mediumSize = props.getProperty("sicherungsMedienGroesseKB");
        try {
            if (mediumSize != null) {
                this._maxMediumSizeKb = Long.parseLong(mediumSize);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String backupDirName = props.getProperty("sicherungsVerzeichnis");
        if (backupDirName == null) {
            throw new IllegalArgumentException("Ben\u00f6tigter Parameter 'sicherungsVerzeichnis' nicht angegeben.");
        }
        File backupDir = new File(backupDirName);
        if (!backupDir.exists()) {
            backupDir.mkdir();
        }
        this.backupBasePath = backupDir.getAbsolutePath();
    }

    @Override
    public boolean hasMediumCapacity(long containerSize, int mediumIndexSize) {
        return this._maxMediumSizeKb * 1024L > this.currentSpaceOccupiedByZipfiles + this.currentSpaceOccupiedByContainers + containerSize + (long)mediumIndexSize;
    }

    @Override
    @NotNull
    public String getBackupPath(int mediumID) {
        return this.backupBasePath + File.separator + "Medium_" + mediumID;
    }

    @Override
    public String toString() {
        return "FileSystem (" + this.backupBasePath + ")";
    }
}

