/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.migration;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.backup.BackupException;
import de.bsvrz.ars.ars.backup.BackupImplementation;
import de.bsvrz.ars.ars.backup.BackupInitializer;
import de.bsvrz.ars.ars.mgmt.ArchiveManager;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.ReadonlyPersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.DirectoryIsLockedException;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.LockFileManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.ars.ars.persistence.layout.ClassicPersistenceDirectoryLayout;
import de.bsvrz.ars.migration.MigrateWorker;
import de.bsvrz.ars.migration.MigrationKey;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Instant;
import java.util.function.Consumer;

public class Migrate {
    public static void main(String[] args) {
        try {
            Migrate.runWithArgs(args);
        }
        catch (IllegalArgumentException e) {
            Migrate.printHelp();
            System.err.println();
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (BackupException e) {
            System.err.println("Das angegebene Backup-Modul konnte nicht geladen werden.");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (PersistenceException e) {
            System.err.println("Bei der Migration trat ein Fehler in der Persistenzschicht auf:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
        catch (Exception e) {
            System.err.println("Bei der Migration trat ein Fehler auf:");
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runWithArgs(String[] args) throws BackupException, PersistenceException, IOException {
        ArgumentList argumentList = new ArgumentList(args);
        Path src = argumentList.fetchArgument("-src").asPath();
        Path dest = argumentList.fetchArgument("-dst").asPath();
        Instant from = argumentList.hasArgument("-from") ? argumentList.fetchArgument("-from").asInstant() : Instant.MIN;
        Instant to = argumentList.hasArgument("-to") ? argumentList.fetchArgument("-to").asInstant() : Instant.MAX;
        String backupProps = argumentList.hasArgument("-backup") ? argumentList.fetchArgument("-backup").asString() : null;
        int threads = argumentList.fetchArgument("-threads=4").intValue();
        Migrate.printArguments(src, dest, from, to, backupProps, threads);
        Debug.init((String)"Migration", (ArgumentList)argumentList);
        argumentList.ensureAllArgumentsUsed();
        BackupImplementation backupModul = BackupInitializer.getBackupModul(backupProps);
        if (!Files.isDirectory(src, new LinkOption[0])) {
            throw new PersistenceException("Quellverzeichnis existiert nicht.");
        }
        if (Files.isDirectory(dest, new LinkOption[0]) && Files.isSameFile(src, dest)) {
            throw new PersistenceException("Quelle und Ziel m\u00fcssen unterschiedliche Verzeichnisse sein.");
        }
        WeekDomain domain = ArchiveManager.detectDomain((Path)src, (boolean)true);
        if (domain != null) {
            throw new PersistenceException("Verzeichnis " + String.valueOf(src.toAbsolutePath()) + " ist leer oder wurde bereits konvertiert.");
        }
        ClassicPersistenceDirectoryLayout layout = ClassicPersistenceDirectoryLayout.Instance;
        var dataIdentificationManager = new DataIdentificationManager(){
            private Consumer<MigrationKey> closeIndexCallback = key -> {};

            public SyncKey<IdDataIdentification> lockIndex(IdDataIdentification dataIdentification) {
                return new MigrationKey(dataIdentification, this.closeIndexCallback);
            }
        };
        ReadonlyPersistenceDirectory srcDir = new ReadonlyPersistenceDirectory(dataIdentificationManager, layout.createInstance(src, 0));
        dataIdentificationManager.closeIndexCallback = arg_0 -> Migrate.lambda$runWithArgs$0((PersistenceDirectory)srcDir, arg_0);
        LockFileManager lockFileManager = new LockFileManager();
        try {
            lockFileManager.open(src);
        }
        catch (DirectoryIsLockedException e) {
            throw new PersistenceException("Verzeichnis " + String.valueOf(src.toAbsolutePath()) + " ist gesperrt.", (Throwable)e);
        }
        try {
            MigrateWorker worker = new MigrateWorker((PersistenceDirectory)srcDir, dest, threads, (Range<Instant>)Range.closedOpen((Comparable)from, (Comparable)to), backupModul);
            worker.start();
        }
        finally {
            lockFileManager.close(src);
        }
    }

    private static void printHelp() {
        System.err.printf("Das Migrationswerkzeug besitzt folgende Argumente:\n     -src=       Erforderlich.\n                 Quellverzeichnis (altes Persistenzverzeichnis)\n\n     -dst=       Erforderlich.\n                 Leeres Zielverzeichnis (zuk\u00fcnftiges Persistenzverzeichnis im neuen Format)\n\n     -from=      Optional. Datum in Format dd.mm.yyyy (z. B. \"31.12.1987\").\n                 Daten konvertieren ab Zeitstempel (Archivzeitstempel)\n                 (Fr\u00fchere Daten werden nicht kopiert)\n\n     -to=        Optional. Datum in Format dd.mm.yyyy (z. B. \"31.12.1987\").\n                 Daten konvertieren bis Zeitstempel (Archivzeitstempel)\n                 (Neuere Daten werden nicht kopiert)\n\n     -backup=    Optional.\n                 .properties-Datei f\u00fcr Backup-Konfiguration, falls ausgelagerte Container\n                 bei der Migration wieder von Sicherungsmedien integriert werden sollen.\n                 Achtung: Dies ist nachtr\u00e4glich nicht m\u00f6glich!\n\n     -threads=   Optional.\n                 Anzahl Threads f\u00fcr die Konvertierung (beeinflusst ggf. Performance)\n%n", new Object[0]);
    }

    private static void printArguments(Path src, Path dest, Instant from, Instant to, String backupProps, int threads) {
        System.err.printf("Das Migrationswerkzeug wurde mit folgenden Parametern gestartet:\n     -src=%s\n                 Quellverzeichnis (altes Persistenzverzeichnis)\n     -dst=%s\n                 Leeres Zielverzeichnis (zuk\u00fcnftiges Persistenzverzeichnis im neuen Format)\n     -from=%s\n                 Daten konvertieren ab Zeitstempel (Archivzeitstempel)\n                 (Fr\u00fchere Daten werden nicht kopiert)\n     -to=%s\n                 Daten konvertieren bis Zeitstempel (Archivzeitstempel)\n                 (Neuere Daten werden nicht kopiert)\n     -backup=%s\n                 .properties-Datei f\u00fcr Backup-Konfiguration, falls ausgelagerte Container\n                 bei der Migration wieder von Sicherungsmedien integriert werden sollen.\n                 Achtung: Dies ist nachtr\u00e4glich nicht m\u00f6glich!\n     -threads=%s\n                 Anzahl Threads f\u00fcr die Konvertierung (beeinflusst ggf. Performance)\n%n", src, dest, from.equals(Instant.MIN) ? "(nicht angegeben)" : from, to.equals(Instant.MAX) ? "(nicht angegeben)" : to, backupProps == null ? "(nicht angegeben)" : backupProps, threads);
    }

    private static /* synthetic */ void lambda$runWithArgs$0(PersistenceDirectory srcDir, MigrationKey key) {
        srcDir.getIndexTree().closeIndexes();
    }
}

