/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.ars.migration;

import com.google.common.collect.Range;
import de.bsvrz.ars.ars.backup.BackupException;
import de.bsvrz.ars.ars.backup.BackupImplementation;
import de.bsvrz.ars.ars.mgmt.datatree.DataIdentTree;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SyncKey;
import de.bsvrz.ars.ars.mgmt.datatree.synchronization.SynchronizationFailedException;
import de.bsvrz.ars.ars.persistence.CacheManager;
import de.bsvrz.ars.ars.persistence.ContainerCreator;
import de.bsvrz.ars.ars.persistence.ContainerDataResult;
import de.bsvrz.ars.ars.persistence.ContainerDirectory;
import de.bsvrz.ars.ars.persistence.ContainerFile;
import de.bsvrz.ars.ars.persistence.ContainerFileHandle;
import de.bsvrz.ars.ars.persistence.ContainerHdr;
import de.bsvrz.ars.ars.persistence.ContainerHeaders;
import de.bsvrz.ars.ars.persistence.ContainerManagementInformation;
import de.bsvrz.ars.ars.persistence.DataIdentificationDir;
import de.bsvrz.ars.ars.persistence.DataIdentificationManager;
import de.bsvrz.ars.ars.persistence.IdDataIdentification;
import de.bsvrz.ars.ars.persistence.LockedContainerDirectory;
import de.bsvrz.ars.ars.persistence.OpenContainerData;
import de.bsvrz.ars.ars.persistence.PersistenceException;
import de.bsvrz.ars.ars.persistence.RebuildMode;
import de.bsvrz.ars.ars.persistence.RestorePersDirTsk;
import de.bsvrz.ars.ars.persistence.StandardOpenContainerData;
import de.bsvrz.ars.ars.persistence.StartupProperties;
import de.bsvrz.ars.ars.persistence.directories.ActivePersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.PersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.ReadonlyPersistenceDirectory;
import de.bsvrz.ars.ars.persistence.directories.mgmt.lock.LockFileManager;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.Week;
import de.bsvrz.ars.ars.persistence.directories.mgmt.range.WeekDomain;
import de.bsvrz.ars.ars.persistence.index.IndexException;
import de.bsvrz.ars.ars.persistence.index.result.IndexResult;
import de.bsvrz.ars.ars.persistence.iter.DataIterator;
import de.bsvrz.ars.ars.persistence.layout.ShortPersistenceDirectoryLayout;
import de.bsvrz.ars.ars.persistence.walk.DataIdentificationDirWalk;
import de.bsvrz.ars.ars.persistence.walk.internal.StatusPrinter;
import de.bsvrz.ars.ars.persistence.writer.SerializableDataset;
import de.bsvrz.ars.ars.persistence.writer.SerializationHelper;
import de.bsvrz.ars.migration.MigrationKey;
import de.bsvrz.dav.daf.main.DataState;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKind;
import de.bsvrz.dav.daf.main.archive.ArchiveDataKindCombination;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.kappich.annotations.NotNull;
import de.bsvrz.sys.funclib.losb.datk.ContainerSettings;
import de.bsvrz.sys.funclib.losb.util.Util;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

public class MigrateWorker
implements ContainerCreator {
    private static final Debug _debug = Debug.getLogger();
    private static final String UNAVAILABLE_MEDIUM_ID_FILE = "_unavailable_mediumids.dat";
    private final Set<String> mediumIdIgnoreSet = new HashSet<String>();
    private final PersistenceDirectory src;
    private final Path target;
    private final BackupImplementation backupImplementation;
    private final AtomicLong containerIdCounter = new AtomicLong();
    private final AtomicLong lastATime = new AtomicLong();
    private final WeekDomain domain;
    private final ConcurrentHashMap<Path, ActivePersistenceDirectory> pathCache = new ConcurrentHashMap();
    private final ContainerSettings.CloseCondition closeConditions;
    private final ThreadLocal<SerializationHelper> serializationHelper;
    private final int numThreads;
    private final Range<Instant> archiveTimeRange;
    private final LockFileManager lockFileManager;

    public MigrateWorker(PersistenceDirectory srcDir, Path target, int numThreads, Range<Instant> archiveTimeRange, BackupImplementation backupImplementation) {
        this.src = srcDir;
        this.target = target;
        this.numThreads = numThreads;
        this.archiveTimeRange = archiveTimeRange;
        this.backupImplementation = backupImplementation;
        this.domain = new WeekDomain();
        this.lockFileManager = new LockFileManager();
        CacheManager.getInstance().setCacheEnabled(false);
        if (Files.exists(target, new LinkOption[0]) && !this.isEmpty(target)) {
            throw new IllegalArgumentException("Zielverzeichnis existiert bereits: " + String.valueOf(target));
        }
        this.closeConditions = new ContainerSettings.CloseCondition();
        this.closeConditions.maxContTime = 1000000L;
        this.closeConditions.maxContSize = 50000000;
        this.closeConditions.maxContAnzDS = 100000;
        this.serializationHelper = ThreadLocal.withInitial(() -> new SerializationHelper(atg -> this.closeConditions, (ContainerCreator)this, false));
        this.initIgnoreList();
    }

    public boolean isEmpty(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean bl;
            block9: {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    boolean bl2 = bl = !stream.iterator().hasNext();
                    if (stream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        return false;
                    }
                }
                stream.close();
            }
            return bl;
        }
        return false;
    }

    public void start() throws PersistenceException {
        this.migrateData();
        this.closeDirectories();
        this.writeStartupProperties();
    }

    private void writeStartupProperties() throws PersistenceException {
        StartupProperties startupProperties = new StartupProperties(this.target);
        startupProperties.setVal(StartupProperties.STUP_MAX_CONT_ID, this.containerIdCounter.get());
        startupProperties.setVal(StartupProperties.STUP_LAST_ATIME, this.lastATime.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDirectories() throws PersistenceException {
        ArrayList<ActivePersistenceDirectory> directories = new ArrayList<ActivePersistenceDirectory>(this.pathCache.values());
        directories.sort(Comparator.comparing(it -> this.domain.ofPath(this.target.relativize(it.getBasePath()))));
        int count = directories.size();
        _debug.info("Schlie\u00dfe " + count + " Verzeichnisse ab.");
        Instant start = Instant.now();
        int finished = 0;
        StatusPrinter statusPrinter = new StatusPrinter();
        for (ActivePersistenceDirectory value : directories) {
            _debug.info(statusPrinter.getStatusMessage("Verzeichnisse abschlie\u00dfen", Duration.between(start, Instant.now()), StatusPrinter.ApproximationType.Exact, (long)count, (long)finished, 0L) + "\nAktuelles Verzeichnis: " + String.valueOf(value));
            try {
                RestorePersDirTsk.RestoreWorker worker = new RestorePersDirTsk.RestoreWorker("Indexe erzeugen", RebuildMode.Full, (DataIdentificationManager)this, this.numThreads);
                worker.doRestore((PersistenceDirectory)value);
                value.closePermanently();
                Path basePath = value.getBasePath();
                this.lockFileManager.close(basePath);
                MigrateWorker.deleteDirectoryIfEmpty(basePath);
            }
            catch (InterruptedException e) {
                _debug.warning("Unterbrochen", (Throwable)e);
                return;
            }
            catch (IOException e) {
                _debug.warning("Lock-Datei konnte nicht gel\u00f6scht werden", (Throwable)e);
            }
            finally {
                value.getIndexTree().closeIndexes();
            }
            ++finished;
        }
    }

    private void migrateData() throws PersistenceException {
        _debug.info("Starte Migration von '" + String.valueOf(this.src) + "' nach '" + String.valueOf(this.target) + "'.");
        DataIdentificationDirWalk walk = DataIdentificationDirWalk.allDirectories((PersistenceDirectory)this.src);
        walk.execute("Migration", this.numThreads, (dataIdentificationDir, walk1) -> new DataIdentificationMigration(dataIdentificationDir).run());
    }

    private static void deleteDirectoryIfEmpty(Path path) {
        try {
            try (Stream<Path> stream = Files.list(path);){
                if (stream.iterator().hasNext()) {
                    return;
                }
            }
            Files.deleteIfExists(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initIgnoreList() {
        block13: {
            Path ignoreFile = this.src.getBasePath().resolve(UNAVAILABLE_MEDIUM_ID_FILE);
            if (!Files.exists(ignoreFile, new LinkOption[0])) {
                _debug.info("Datei _unavailable_mediumids.dat existiert nicht.");
                return;
            }
            try {
                BufferedReader br = Files.newBufferedReader(ignoreFile, StandardCharsets.ISO_8859_1);
                block9: while (true) {
                    String s;
                    while ((s = br.readLine()) != null) {
                        try {
                            int mediumID = Integer.parseInt(s.trim());
                            this.mediumIdIgnoreSet.add(String.valueOf(mediumID));
                            continue block9;
                        }
                        catch (NumberFormatException numberFormatException) {
                        }
                    }
                    break block13;
                    {
                        continue block9;
                        break;
                    }
                    break;
                }
                finally {
                    if (br != null) {
                        br.close();
                    }
                }
            }
            catch (IOException e) {
                _debug.warning("Exception trat beim Lesen der Datei _unavailable_mediumids.dat auf. Wiederherstellung verwendet keine MedienID-Ignore-Liste.", (Throwable)e);
            }
        }
    }

    private boolean isMediumIdToBeRestored(String mediumID) {
        return !mediumID.equals("destroyed ") && !mediumID.equals("unsaved   ") && !this.mediumIdIgnoreSet.contains(mediumID);
    }

    private SyncKey<IdDataIdentification> getLock(DataIdentificationDir dataIdentificationDir) {
        return this.getLock(dataIdentificationDir.getDataIdentification());
    }

    private SyncKey<IdDataIdentification> getLock(IdDataIdentification dataIdentification) {
        return new MigrationKey(dataIdentification, key -> {
            for (ActivePersistenceDirectory value : this.pathCache.values()) {
                value.getIndexTree().closeIndexes();
            }
        });
    }

    public long nextContainerID() {
        return this.containerIdCounter.incrementAndGet();
    }

    public SyncKey<IdDataIdentification> lockIndex(IdDataIdentification dataIdentification) {
        return this.getLock(dataIdentification);
    }

    public DataIdentTree getDataIdentTree() {
        return null;
    }

    @NotNull
    private ActivePersistenceDirectory createPersistenceDirectory(Path targetDir) throws UncheckedIOException {
        try {
            this.lockFileManager.createWritable(targetDir);
            return new ActivePersistenceDirectory((ContainerCreator)this, ShortPersistenceDirectoryLayout.Instance.createInstance(targetDir, 0));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ContainerFileHandle restoreFromBackup(int backupMediumID, LockedContainerDirectory directory, long containerId, Path tempDirectory) throws PersistenceException, BackupException, IOException {
        if (this.backupImplementation == null) {
            return null;
        }
        long startTime = Util.startTimer();
        String containerFileName = ContainerFile.getContainerFileName((long)containerId);
        ReadonlyPersistenceDirectory tmpDir = new ReadonlyPersistenceDirectory((DataIdentificationManager)this, ShortPersistenceDirectoryLayout.Instance.createInstance(tempDirectory, 0));
        try (InputStream is = this.backupImplementation.restoreContainer(backupMediumID, containerFileName);){
            if (is == null) {
                _debug.warning("Container " + containerFileName + " nicht gefunden.");
                ContainerFileHandle containerFileHandle = null;
                return containerFileHandle;
            }
            Path targetDir = tmpDir.getPath((ContainerDirectory)directory);
            Files.createDirectories(targetDir, new FileAttribute[0]);
            Path file = targetDir.resolve(containerFileName);
            try (OutputStream fos = Files.newOutputStream(file, new OpenOption[0]);){
                Util.copyStreams((InputStream)is, (OutputStream)fos);
            }
        }
        catch (BackupException | IOException e) {
            _debug.error("Wiederherstellung fehlgeschlagen.", (Throwable)e);
            throw e;
        }
        ContainerFileHandle handle = tmpDir.accessContainer(directory, ContainerFile.getContID((String)containerFileName));
        handle.readContainerHeader();
        handle.setContainerHeaderParam(ContainerHdr.CHP_LOESCHUTZ, 0L);
        handle.setContainerHeaderParam(ContainerHdr.CHP_RESTORED, "1");
        handle.setContainerHeaderParam(ContainerHdr.CHP_MEDIUM_ID, Util.leadZero((long)backupMediumID, (int)ContainerHdr.CHP_MEDIUM_ID.getValLen()));
        handle.writeContainerHeaderWithoutUpdatingIndex();
        _debug.info("Container " + containerFileName + " erfolgreich wiederhergestellt (" + Util.stopTimer((long)startTime) + " sec.)");
        return handle;
    }

    private class DataIdentificationMigration {
        private final DataIdentificationDir dataIdentificationDir;
        private ActivePersistenceDirectory prevDirectory;
        private Week prevTimeRange;

        public DataIdentificationMigration(DataIdentificationDir dataIdentificationDir) {
            this.dataIdentificationDir = dataIdentificationDir;
        }

        public void run() throws PersistenceException, IndexException, SynchronizationFailedException, ExecutionException, InterruptedException {
            if (this.dataIdentificationDir.getDataIdentification().getSimVariant() != 0) {
                return;
            }
            for (ArchiveDataKind adk : this.dataIdentificationDir.getArchiveDataKinds()) {
                SyncKey<IdDataIdentification> lock = MigrateWorker.this.getLock(this.dataIdentificationDir);
                LockedContainerDirectory containerDirectory = new LockedContainerDirectory(lock, adk);
                IndexResult indexResult = MigrateWorker.this.src.getContainerHeaders(containerDirectory);
                for (int i = 0; i < indexResult.size(); ++i) {
                    ContainerHeaders containerHeaders = new ContainerHeaders(indexResult, (IdDataIdentification)lock.getElement(), adk, i);
                    this.handleContainer(containerDirectory, containerHeaders);
                }
                MigrateWorker.this.src.getIndexTree().closeIndexes();
                _debug.fine("Verzeichnis abgeschlossen: " + String.valueOf(containerDirectory));
                this.dataIdentificationDir.getPersistenceDirectory().getIndexTree().closeIndexes(containerDirectory);
            }
        }

        private void handleContainer(LockedContainerDirectory directory, ContainerHeaders containerHeaders) throws IndexException, SynchronizationFailedException, PersistenceException, ExecutionException, InterruptedException {
            ContainerDataResult tmp = new ContainerDataResult();
            long contMinArcTime = containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MIN);
            long contMaxArcTime = containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX);
            Range containerRange = Range.closed((Comparable)Instant.ofEpochMilli(contMinArcTime), (Comparable)Instant.ofEpochMilli(contMaxArcTime));
            long containerId = containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID);
            boolean isDeleted = containerHeaders.getContainerHeaderParamAsBoolean(ContainerManagementInformation.CHP_DELETED);
            if (!MigrateWorker.this.archiveTimeRange.isConnected(containerRange)) {
                _debug.fine("Daten von Container " + containerId + " sind nicht im Zeitbereich.");
            }
            if (isDeleted) {
                String mediumId = containerHeaders.getContainerHeaderParamAsString(ContainerManagementInformation.CHP_MEDIUM_ID);
                if (MigrateWorker.this.isMediumIdToBeRestored(mediumId)) {
                    this.restoreFromMedium(directory, containerHeaders, mediumId, containerId, contMaxArcTime, tmp);
                } else {
                    this.writeUnavailableBlock(containerHeaders, this.updateOutDir(contMaxArcTime, this.dataIdentificationDir));
                }
                return;
            }
            try (DataIterator iterator = MigrateWorker.this.src.iterator(directory.archiveDataKind(), containerId, directory.dataIdentification());){
                while (!iterator.isEmpty()) {
                    iterator.poll(tmp);
                    if (!MigrateWorker.this.archiveTimeRange.contains((Comparable)Instant.ofEpochMilli(tmp.getArchiveTime()))) continue;
                    this.writeToOutput(tmp, (ContainerDirectory)directory, this.updateOutDir(tmp.getArchiveTime(), this.dataIdentificationDir));
                }
            }
        }

        /*
         * Exception decompiling
         */
        private void restoreFromMedium(LockedContainerDirectory directory, ContainerHeaders containerHeaders, String mediumId, long containerId, long contMaxArcTime, ContainerDataResult tmp) throws PersistenceException, IndexException, SynchronizationFailedException, ExecutionException, InterruptedException {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[TRYBLOCK]], but top level block is 30[UNCONDITIONALDOLOOP]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private void writeUnavailableBlock(ContainerHeaders containerHeaders, ActivePersistenceDirectory persistenceDirectory) throws IndexException, SynchronizationFailedException, PersistenceException, ExecutionException, InterruptedException {
            ContainerDataResult result = new ContainerDataResult();
            result.setArchiveTime(containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_ARC_TIME_MAX));
            result.setDataTime(containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_TIME_MAX));
            result.setDataIndex(containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_DATA_IDX_MAX));
            result.setContainerID(containerHeaders.getContainerHeaderParamAsLong(ContainerManagementInformation.CHP_CONT_ID));
            result.setDataUncompressedSize(0);
            result.setCompressed(false);
            result.setData(null);
            result.setDataKind(containerHeaders.getLocation().archiveDataKind());
            result.setDataState(DataState.POSSIBLE_GAP);
            this.writeToOutput(result, containerHeaders.getLocation(), persistenceDirectory);
        }

        private void writeToOutput(ContainerDataResult result, ContainerDirectory location, ActivePersistenceDirectory persistenceDirectory) throws IndexException, SynchronizationFailedException, PersistenceException {
            MigrateWorker.this.lastATime.accumulateAndGet(result.getArchiveTime(), Math::max);
            SerializableDataset dataset = SerializableDataset.create((ContainerDataResult)result);
            MigrateWorker.this.serializationHelper.get().writeData(dataset, persistenceDirectory, location);
        }

        private ActivePersistenceDirectory updateOutDir(long archiveTime, DataIdentificationDir dataIdentificationDir) throws PersistenceException {
            Week timeRange = MigrateWorker.this.domain.ofEpochMillis(archiveTime);
            if (timeRange.equals((Object)this.prevTimeRange)) {
                return this.prevDirectory;
            }
            if (this.prevDirectory != null) {
                for (ArchiveDataKind archiveDataKind : ArchiveDataKindCombination.all()) {
                    LockedContainerDirectory containerDirectory = new LockedContainerDirectory(MigrateWorker.this.getLock(dataIdentificationDir), archiveDataKind);
                    this.closeOpenContainer(containerDirectory);
                }
            }
            this.prevTimeRange = timeRange;
            Path targetDir = MigrateWorker.this.target.resolve(MigrateWorker.this.domain.getPath(timeRange));
            this.prevDirectory = MigrateWorker.this.pathCache.computeIfAbsent(targetDir, path -> MigrateWorker.this.createPersistenceDirectory(targetDir));
            return this.prevDirectory;
        }

        private void closeOpenContainer(LockedContainerDirectory containerDirectory) throws PersistenceException {
            OpenContainerData openContainerData = this.prevDirectory.getLoadedContainerData((ContainerDirectory)containerDirectory);
            if (openContainerData instanceof StandardOpenContainerData) {
                StandardOpenContainerData containerData = (StandardOpenContainerData)openContainerData;
                try (ContainerFileHandle containerFileHandle = this.prevDirectory.accessOpenContainer((ContainerDirectory)containerDirectory, containerData.getContainerId());){
                    ContainerFile cf = containerFileHandle.getContainerFile();
                    cf.closeContainer(containerData);
                    this.prevDirectory.removeOpenContainerData((ContainerDirectory)containerDirectory);
                }
            }
        }
    }
}

