/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.zeitverw;

import de.bsvrz.sys.dcf77.zeitverw.DCFdav;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.IntpTrigger;
import de.bsvrz.sys.funclib.debug.Debug;

public class SenderThread
extends Thread
implements IntpTrigger {
    private Debug _debug = Debug.getLogger();
    private IntpAllgemein m_ntpAllgemein;
    private DCFdav m_dcfDAV;
    private long m_zyklusZeit;
    private DataAspZustand m_dataAspZustandNeu = new DataAspZustand();
    private boolean m_schreibeInDav = true;
    private DataAspZustand m_dataAspZustandAlt = new DataAspZustand();
    Boolean m_shutDown = false;
    private Boolean m_erstesMal = true;
    private long m_zyklusCount = 0L;
    private long m_zyklusCountMax = -1L;

    public void set_schreibeInDav(boolean schreibeInDav) {
        this.m_schreibeInDav = schreibeInDav;
    }

    public DataAspZustand get_dataAspZustandNeu() {
        return this.m_dataAspZustandNeu;
    }

    public void set_shutDown() {
        this.m_shutDown = true;
        this.setTrigger();
    }

    public SenderThread(IntpAllgemein ntpAllgemein, DCFdav dcfDAV, long zyklusZeit) {
        this.initialize_SenderThread(ntpAllgemein, dcfDAV, zyklusZeit, -1L);
    }

    public SenderThread(IntpAllgemein ntpAllgemein, DCFdav dcfDAV, long zyklusZeit, long zyklusCountMax) {
        this.initialize_SenderThread(ntpAllgemein, dcfDAV, zyklusZeit, zyklusCountMax);
    }

    private void initialize_SenderThread(IntpAllgemein ntpAllgemein, DCFdav dcfDAV, long zyklusZeit, long zyklusCountMax) {
        this.m_ntpAllgemein = ntpAllgemein;
        this.m_dcfDAV = dcfDAV;
        this.m_zyklusZeit = zyklusZeit * 1000L;
        this.m_erstesMal = true;
        this.m_zyklusCountMax = zyklusCountMax;
    }

    private SenderThread() {
    }

    @Override
    public synchronized void run() {
        this.mywait(1000L);
        if (this.isInterrupted()) {
            this._debug.fine("SenderThread isInterrupted");
        }
        while (!this.isInterrupted() && !this.m_shutDown.booleanValue() && this.m_zyklusCountMax != this.m_zyklusCount) {
            this.mywait(this.m_zyklusZeit);
            this.leseUndSendeNTPStatus();
            ++this.m_zyklusCount;
        }
        System.out.println("Der Thread de.bsvrz.sys.dfctest.zeitverw.SenderThread wurde beendet!");
    }

    public boolean leseNTPStatus() {
        this.m_dataAspZustandAlt.copy(this.m_dataAspZustandNeu);
        this.m_dataAspZustandNeu.copy(this.m_ntpAllgemein.getAktuellerZeitServer(), this.m_ntpAllgemein.getVorhandeneZeitServer(), this.m_ntpAllgemein.getZeitKorrektur());
        Boolean aenderung = !this.m_dataAspZustandAlt.equals(this.m_dataAspZustandNeu);
        if (!aenderung.booleanValue()) {
            System.out.println("SenderThread: keine Aktion");
        }
        return aenderung;
    }

    private void sendeNTPStatus() {
        System.out.println("SenderThread: sende neuen Zustand");
        this.m_dataAspZustandNeu.aus("SenderThread_Sendung");
        this.m_dcfDAV.sendDavZustand(this.m_dataAspZustandNeu);
    }

    private void leseUndSendeNTPStatus() {
        Boolean aenderung = this.leseNTPStatus();
        if (this.m_schreibeInDav && aenderung.booleanValue()) {
            this.sendeNTPStatus();
        }
    }

    private void leseUndSendeNTPStatusOld() {
        this.m_dataAspZustandAlt.copy(this.m_dataAspZustandNeu);
        this.m_dataAspZustandNeu.copy(this.m_ntpAllgemein.getAktuellerZeitServer(), this.m_ntpAllgemein.getVorhandeneZeitServer(), this.m_ntpAllgemein.getZeitKorrektur());
        Boolean keineAenderung = this.m_dataAspZustandAlt.equals(this.m_dataAspZustandNeu);
        if (keineAenderung.booleanValue()) {
            System.out.println("SenderThread: keine Aktion");
            return;
        }
        System.out.println("SenderThread: sende neuen Zustand");
        this.m_dataAspZustandNeu.aus("SenderThread_Sendung");
        this.m_dcfDAV.sendDavZustand(this.m_dataAspZustandNeu);
    }

    @Override
    public synchronized void setTrigger() {
        this.notify();
        System.out.println(" SenderThread.setTrigger gerufen ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void mywait(long timeout) {
        if (this.m_erstesMal.booleanValue()) {
            this.m_erstesMal = false;
            return;
        }
        try {
            if (timeout < 0L) {
                this.wait();
            } else {
                this.wait(timeout);
            }
        }
        catch (InterruptedException e) {
            System.out.println("SenderThread.mywait: InterruptedException Caught");
        }
        catch (Exception e) {
            System.out.println("SenderThread.mywait: Exception Caught");
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        finally {
            System.out.println("ServerThread: Wartezyklus beendet");
        }
    }

    public void dataRequest(Object object, Object dataDescription, byte state) {
    }

    public boolean isRequestSupported(Object object, Object dataDescription) {
        return false;
    }

    public static void main(String[] args) {
        SenderThread senderThread = new SenderThread();
        if (senderThread.m_dataAspZustandAlt == null) {
            System.out.println("Ist Null");
        } else {
            senderThread.m_dataAspZustandAlt.aus();
        }
        if (senderThread.m_dataAspZustandAlt.equals(null)) {
            System.out.println("gleich");
        } else {
            System.out.println("verschieden");
        }
    }
}

