/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6ClientCredentials;
import com.nimbusds.srp6.SRP6ClientSession;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6VerifierGenerator;
import com.nimbusds.srp6.cli.SRP6Tool;
import java.io.IOException;
import java.math.BigInteger;

public class SRP6Client
extends SRP6Tool {
    @Override
    public void run() throws IOException {
        String mode;
        System.out.println("*** Nimbus SRP-6a client / verifier generator ***");
        System.out.println();
        System.out.println("Choose mode: ");
        System.out.println("\t1 = generate password verifier");
        System.out.println("\t2 = client auth session");
        System.out.println();
        System.out.print("Your choice [1]: ");
        switch (mode = this.readInput("1")) {
            case "1": {
                System.out.println();
                this.generatePasswordVerifier();
                break;
            }
            case "2": {
                System.out.println();
                this.clientSession();
                break;
            }
            default: {
                System.out.println("Unknown choice, aborting...");
            }
        }
    }

    private void generatePasswordVerifier() throws IOException {
        int saltBytes;
        System.out.println("Initialize verifier generator");
        SRP6CryptoParams config = this.getConfig("\t");
        SRP6VerifierGenerator vGen = new SRP6VerifierGenerator(config);
        User user = this.getUser("");
        System.out.println();
        System.out.print("Enter preferred salt 's' byte size [16]: ");
        String ss = this.readInput("16");
        try {
            saltBytes = Integer.parseInt(ss);
        }
        catch (NumberFormatException e) {
            System.out.println("Couldn't parse salt 's' byte size: " + e.getMessage());
            return;
        }
        BigInteger s = BigIntegerUtils.bigIntegerFromBytes(SRP6VerifierGenerator.generateRandomSalt(saltBytes));
        BigInteger v = vGen.generateVerifier(s, user.I, user.P);
        System.out.println("Generated salt 's' (hex): " + BigIntegerUtils.toHex(s));
        System.out.println();
        System.out.println("Computed password verifier 'v' (hex): " + BigIntegerUtils.toHex(v));
    }

    private void clientSession() throws IOException {
        SRP6ClientCredentials cred;
        System.out.println("Client session step 1");
        SRP6ClientSession client = new SRP6ClientSession();
        User user = this.getUser("\t");
        client.step1(user.I, user.P);
        System.out.println();
        System.out.println("Client session step 2");
        SRP6CryptoParams config = this.getConfig("\t");
        System.out.print("\tEnter salt 's' (hex): ");
        BigInteger s = this.readBigInteger();
        System.out.println();
        System.out.print("\tEnter public server value 'B' (hex): ");
        BigInteger B = this.readBigInteger();
        System.out.println();
        try {
            cred = client.step2(config, s, B);
        }
        catch (SRP6Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println("\tComputed public value 'A' (hex): " + BigIntegerUtils.toHex(cred.A));
        System.out.println("\tComputed evidence message 'M1' (hex): " + BigIntegerUtils.toHex(cred.M1));
        System.out.println();
        System.out.println("Client session step 3");
        System.out.print("\tEnter server evidence message 'M2' (hex): ");
        BigInteger M2 = this.readBigInteger();
        try {
            client.step3(M2);
        }
        catch (SRP6Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println();
        System.out.println("Client authentication successfully completed");
    }

    private User getUser(String prefix) throws IOException {
        System.out.print(prefix + "Enter user identity 'I': ");
        String I = this.readInput();
        System.out.print(prefix + "Enter user password 'P': ");
        String P = this.readInput();
        return new User(I, P);
    }

    public static void main(String[] args) throws Exception {
        SRP6Client client = new SRP6Client();
        client.run();
    }

    public static class User {
        public final String I;
        public final String P;

        public User(String I, String P) {
            this.I = I;
            this.P = P;
        }
    }
}

