/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.lib;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class UtlDateTime {
    public static Date zeit2date(long zeitMs) {
        return new Date(zeitMs);
    }

    public static String zeit2String(Long zeitMs) {
        if (zeitMs == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
        String formattedDate = formatter.format(new Date(zeitMs));
        return formattedDate;
    }

    public static String date2String(Date date, String dateFormat) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        String formattedDate = formatter.format(date);
        return formattedDate;
    }

    public static String date2String(Date date) {
        return UtlDateTime.date2String(date, "dd.MM.yyyy HH:mm:ss");
    }

    public static Long string2Zeit(String datumsString) {
        return UtlDateTime.string2Zeit(datumsString, false);
    }

    public static Long string2Zeit(String datumsString, boolean useLenient) {
        String dateFormat = "dd.MM.yyyy HH:mm:ss";
        return UtlDateTime.string2Zeit(datumsString, dateFormat, useLenient);
    }

    public static Long string2Zeit(String datumsString, String dateFormat, boolean useLenient) {
        SimpleDateFormat formatter = new SimpleDateFormat(dateFormat);
        Date date = null;
        if (!useLenient) {
            formatter.setLenient(false);
        }
        try {
            date = formatter.parse(datumsString);
        }
        catch (ParseException e) {
            System.err.println("Format ungueltig: " + datumsString);
            return null;
        }
        return date.getTime();
    }

    public static Long getTagesanfang(Long zeitMs) {
        if (zeitMs < 10L) {
            zeitMs = new Date().getTime() + zeitMs * 24L * 3600L * 1000L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(zeitMs);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTimeInMillis();
    }

    public static Long getJahresanfang(Long zeitMs) {
        Long tagesanfang = UtlDateTime.getTagesanfang(zeitMs);
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(tagesanfang);
        cal.set(5, 1);
        cal.set(2, 0);
        return cal.getTimeInMillis();
    }

    public static Long getTagesende(Long zeitMs) {
        if (zeitMs < 10L) {
            zeitMs = new Date().getTime() + zeitMs * 24L * 3600L * 1000L;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(zeitMs);
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        cal.set(14, 999);
        return cal.getTimeInMillis();
    }

    public static int extractFieldValues(long zeitMs, int field) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(zeitMs);
        int val = cal.get(field);
        if (field == 2) {
            ++val;
        }
        return val;
    }

    public static long fields2Zeit(int year, int month, int day_of_month, int hour_of_day, int minute, int second) {
        Calendar cal = Calendar.getInstance();
        cal.set(year, month - 1, day_of_month, hour_of_day, minute, second);
        long zeitMs = cal.getTimeInMillis();
        return zeitMs;
    }

    public static void testGetTagesAE() {
        UtlDateTime.getTagesanfang(0L);
        String message = "heute:";
        message = message + UtlDateTime.zeit2String(UtlDateTime.getTagesanfang(0L));
        message = message + "   " + UtlDateTime.zeit2String(UtlDateTime.getTagesende(0L));
        System.out.println(message);
        message = "gestern:";
        message = message + UtlDateTime.zeit2String(UtlDateTime.getTagesanfang(-1L));
        message = message + "   " + UtlDateTime.zeit2String(UtlDateTime.getTagesende(-1L));
        System.out.println(message);
    }

    public static boolean amSelbenTag(Long zp1, Long zp2) {
        int tag2;
        Boolean bret = false;
        if (zp1 == null || zp2 == null) {
            return false;
        }
        int tag1 = UtlDateTime.extractFieldValues(zp1, 5);
        if (tag1 == (tag2 = UtlDateTime.extractFieldValues(zp2, 5)) && Math.abs(zp1 - zp2) < 86400000L) {
            bret = true;
        }
        return bret;
    }

    public static void testAmSelbenTag() {
        boolean bret = true;
        long zp1 = UtlDateTime.string2Zeit("13.04.2008 14:30:00");
        long zp2 = UtlDateTime.string2Zeit("13.04.2008 17:30:00");
        if (!UtlDateTime.amSelbenTag(zp1, zp2)) {
            bret = false;
        }
        zp1 = UtlDateTime.string2Zeit("13.04.2008 17:30:00");
        zp2 = UtlDateTime.string2Zeit("13.04.2008 14:00:00");
        if (!UtlDateTime.amSelbenTag(zp1, zp2)) {
            bret = false;
        }
        zp1 = UtlDateTime.string2Zeit("13.04.2008 14:30:00");
        zp2 = UtlDateTime.string2Zeit("13.03.2008 14:30:00");
        if (UtlDateTime.amSelbenTag(zp1, zp2)) {
            bret = false;
        }
        if (bret) {
            String meldung = "Test erfolgreich";
            System.out.println(meldung);
        } else {
            String meldung = "Test fehlgeschlagen";
            System.err.println(meldung);
        }
    }

    public static void testFields2Zeit() {
        long zeitMs = UtlDateTime.fields2Zeit(2007, 4, 28, 15, 28, 3);
        System.out.println(UtlDateTime.zeit2String(zeitMs));
    }

    public static void testFieldValues() {
        long zeitMs = UtlDateTime.string2Zeit("29.04.2008 15:32:28");
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 5));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 2));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 1));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 11));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 10));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 12));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 13));
        System.out.println(UtlDateTime.extractFieldValues(zeitMs, 14));
    }

    public static void main(String[] args) {
        String ss = UtlDateTime.date2String(new Date(), "dd.MM.yyyy HH:mm:ss,SSS");
        System.out.println(ss);
    }
}

