/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.ntp;

import de.bsvrz.sys.dcf77.lib.UtlDateTime;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.IntpTrigger;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class DefaultNtp2
implements IntpAllgemein {
    private Timer timerObj = new Timer(true);
    String m_aktuellerZS = "n/a";
    private DataAspZustand m_aktuellerZustand = new DataAspZustand();
    public IntpTrigger m_ntpTrigger;

    public DefaultNtp2() {
        System.out.println("Objekt TestNtpServer initialisiert");
        long pollingIntervall = 10100L;
        this.timerObj.schedule((TimerTask)new NtpStatusNotifier(), 0L, pollingIntervall);
    }

    @Override
    public String getAktuellerZeitServer() {
        return this.m_aktuellerZustand.aktuellerZeitserver;
    }

    @Override
    public String getZeitKorrektur() {
        return this.m_aktuellerZustand.letzteKorrekturZeit;
    }

    @Override
    public String[] getVorhandeneZeitServer() {
        return this.m_aktuellerZustand.vorhandeneZeitserver;
    }

    @Override
    public void setInstance(IntpTrigger ntpTrigger) {
        this.m_ntpTrigger = ntpTrigger;
    }

    public void setAktuellerZustand(DataAspZustand aktuellerZustand, Boolean wakeSenderThread) {
        this.m_aktuellerZustand = aktuellerZustand;
        if (wakeSenderThread.booleanValue() && this.m_ntpTrigger != null) {
            this.m_ntpTrigger.setTrigger();
            System.out.println("SenderThread geweckt.");
        }
    }

    public void stop() {
        this.timerObj.cancel();
    }

    public void setAktuellerZustand(DataAspZustand aktuellerZustand) {
        this.setAktuellerZustand(aktuellerZustand, false);
    }

    public void generiereZustand() {
        String letzteKorrekturZeit;
        long aktuelleZeit = new Date().getTime();
        int minute = UtlDateTime.extractFieldValues(aktuelleZeit, 12);
        this.m_aktuellerZustand.aktuellerZeitserver = this.m_aktuellerZS = "ZEITSERVER_" + minute + "(*)";
        int millis = UtlDateTime.extractFieldValues(aktuelleZeit, 14);
        System.out.println(millis);
        double millisD = (double)millis / 1000.0;
        System.out.println(millisD);
        String[] vorZeits = new String[]{this.m_aktuellerZS, "ZEITSERVER_X", "ZEITSERVER_Y"};
        this.m_aktuellerZustand.vorhandeneZeitserver = vorZeits;
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
        String mydate = formatter.format(today);
        this.m_aktuellerZustand.letzteKorrekturZeit = letzteKorrekturZeit = mydate + "," + millisD;
        if (this.m_ntpTrigger != null) {
            this.m_ntpTrigger.setTrigger();
        }
    }

    public static void main(String[] args) {
        long aktuelleZeit = new Date().getTime();
        int minute = UtlDateTime.extractFieldValues(aktuelleZeit, 12);
        int millis = UtlDateTime.extractFieldValues(aktuelleZeit, 14);
        System.out.println(millis);
        double millisD = (double)millis / 1000.0;
        System.out.println(millisD);
    }

    private class NtpStatusNotifier
    extends TimerTask {
        private NtpStatusNotifier() {
        }

        @Override
        public void run() {
            DefaultNtp2.this.generiereZustand();
            System.out.println("ACTION");
        }

        public void stop() {
            DefaultNtp2.this.timerObj.cancel();
        }
    }
}

