/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.ntp.realclient;

import de.bsvrz.sys.dcf77.ntp.realclient.RealNTPClient;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.funclib.debug.Debug;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.regex.Pattern;

public class NTPinfoPoller
extends Thread {
    private Debug _debug = Debug.getLogger();
    private String m_cmd;
    private RealNTPClient m_realNTPClient;
    private NtpServerInfo m_lastNtpServerInfo = null;
    private int m_failCount = 0;
    private Boolean m_shutDown = false;
    private long m_zyklusZeit;
    private Boolean m_erstesMal = true;
    private long m_zyklusCount = 0L;
    private long m_zyklusCountMax = 5L;
    private long m_oschwelle = -1L;
    private final int REMOTE = 0;
    private final int REFID = 1;
    private final int ST = 2;
    private final int WHEN = 4;
    private final int REACH = 6;
    private final int OFFSET = 8;
    private final int JITTER = 9;

    public void set_shutDown() {
        this.m_shutDown = true;
    }

    public NTPinfoPoller(String cmd, RealNTPClient realNTPClient, long zyklusZeit, long zyklusCountMax, long oschwelle) {
        this.m_cmd = cmd;
        this.m_realNTPClient = realNTPClient;
        this.m_zyklusZeit = zyklusZeit;
        this.m_zyklusCountMax = zyklusCountMax;
        this.m_oschwelle = oschwelle;
        System.out.println("OSCWELLE=" + this.m_oschwelle);
    }

    private void checkNewServerInfo() {
        NtpServerInfo ntpServerInfo = new NtpServerInfo();
        int ret = this.readData(this.m_cmd, ntpServerInfo);
        this.m_failCount = ret < 0 ? ++this.m_failCount : 0;
        if (this.m_failCount > 1000) {
            this.set_shutDown();
        }
        if (!ntpServerInfo.equals(this.m_lastNtpServerInfo) || this.m_failCount == 20) {
            DataAspZustand aktuellerZustand = this.cpNtpServerInfo2DataAspZustand(ntpServerInfo);
            this.m_realNTPClient.setAktuellerZustand(aktuellerZustand, true);
        }
        this.m_lastNtpServerInfo = ntpServerInfo;
    }

    private DataAspZustand cpNtpServerInfo2DataAspZustand(NtpServerInfo ntpServerInfo) {
        String[] vorhandeneZeitserver;
        int size = ntpServerInfo.vorhandeneZeitserver.size();
        if (size == 0) {
            vorhandeneZeitserver = new String[]{"n/a"};
        } else {
            vorhandeneZeitserver = new String[size];
            int i = 0;
            Iterator<String> iterator = ntpServerInfo.vorhandeneZeitserver.iterator();
            while (iterator.hasNext()) {
                vorhandeneZeitserver[i] = iterator.next();
                ++i;
            }
        }
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
        String mydate = formatter.format(today);
        String letzteKorrekturZeit = mydate + "," + ntpServerInfo.offset;
        DataAspZustand dataAspZustand = new DataAspZustand(ntpServerInfo.aktuellerZeitserver, vorhandeneZeitserver, letzteKorrekturZeit);
        return dataAspZustand;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readData(String cmd, NtpServerInfo ntpServerInfo) {
        Process p;
        BufferedReader stdError;
        BufferedReader stdInput;
        String s;
        block12: {
            block11: {
                Boolean bret;
                if (cmd.equals("NULLCOMM")) {
                    System.out.println("NULL Command. No Action.");
                    return 1;
                }
                s = null;
                stdInput = null;
                stdError = null;
                p = null;
                p = Runtime.getRuntime().exec(this.m_cmd);
                this._debug.finest("Kommando #" + this.m_cmd + "# wurde abgesetzt.");
                stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                if (p != null && stdInput != null && stdError != null) {
                    this._debug.finest("Alle Variablen zur Verarbeitung des Kommandos initialisiert.");
                }
                if ((bret = this.warteBereit(stdError, stdInput)).booleanValue()) break block11;
                String errMessg = "Kommando \"" + this.m_cmd + "\" antwortet nicht.";
                this._debug.warning(errMessg);
                int n = -1;
                this.destroyProcess(p);
                this.myClose(stdInput);
                this.myClose(stdError);
                return n;
            }
            String cmdError = new String();
            Boolean flgCmdError = false;
            while (stdError.ready() && (s = stdError.readLine()) != null) {
                cmdError = cmdError + "\n" + s;
                flgCmdError = true;
            }
            if (!flgCmdError.booleanValue()) break block12;
            String errMessg = "Kommando \"" + this.m_cmd + "\" meldet Fehler.";
            errMessg = errMessg + "\n" + cmdError;
            this._debug.warning(errMessg);
            int n = -1;
            this.destroyProcess(p);
            this.myClose(stdInput);
            this.myClose(stdError);
            return n;
        }
        try {
            String cmdOutput = new String();
            while (stdInput.ready() && (s = stdInput.readLine()) != null) {
                cmdOutput = cmdOutput + "\n" + s;
            }
            this._debug.finest("Antwort auf das Kommando: #" + cmdOutput);
            this.parseInfo(cmdOutput, ntpServerInfo);
            if (ntpServerInfo.aktuellerZeitserver != "n/a" || ntpServerInfo.ersatzOffset != null) {
                // empty if block
            }
            int n = 1;
            this.destroyProcess(p);
            this.myClose(stdInput);
            this.myClose(stdError);
            return n;
        }
        catch (Exception e) {
            try {
                String errMssg = "Die Verarbeitung von \"" + this.m_cmd + "\" ist fehlgeschlagen.";
                errMssg = errMssg + "\n" + e.getMessage();
                this._debug.warning(errMssg);
                e.printStackTrace();
                int n = -1;
                this.destroyProcess(p);
                this.myClose(stdInput);
                this.myClose(stdError);
                return n;
            }
            catch (Throwable throwable) {
                this.destroyProcess(p);
                this.myClose(stdInput);
                this.myClose(stdError);
                throw throwable;
            }
        }
    }

    private void destroyProcess(Process p) {
        if (p == null) {
            return;
        }
        this.myClose(p.getInputStream());
        this.myClose(p.getErrorStream());
        this.myClose(p.getOutputStream());
        p.destroy();
    }

    public void myClose(Closeable c) {
        boolean isStdStream;
        if (c == null) {
            return;
        }
        boolean bl = isStdStream = c == System.out || c == System.in || c == System.err;
        if (!isStdStream) {
            try {
                c.close();
            }
            catch (IOException e) {
                String errMssg = "c.close() fehlgeschlagen";
                this._debug.warning(errMssg);
                System.err.println(errMssg);
            }
        }
    }

    private Boolean warteBereit(BufferedReader br1, BufferedReader br2) throws IOException, InterruptedException {
        int zaehler;
        int warteZeit = 50;
        int maxWaits = (6000 - 3 * warteZeit) / 500 + 1 + 3;
        for (zaehler = 0; zaehler < maxWaits && !br2.ready() && !br1.ready(); ++zaehler) {
            if (zaehler == 3) {
                warteZeit = 500;
            }
            Thread.sleep(warteZeit);
        }
        if (zaehler < maxWaits) {
            return true;
        }
        return false;
    }

    private void parseInfo(String cmdInfo, NtpServerInfo ntpServerInfo) {
        this._debug.finest("Beginn der Verarbeitung der Antwort");
        Pattern p = Pattern.compile("[\n]");
        String[] lines = p.split(cmdInfo);
        boolean trenner = false;
        for (String zeile : lines) {
            this._debug.finest("Zeile: " + zeile);
            if (trenner) {
                this.parseInfoLine(zeile, ntpServerInfo);
            }
            if (!zeile.startsWith("====")) continue;
            trenner = true;
        }
        Collections.sort(ntpServerInfo.vorhandeneZeitserver);
    }

    private void parseInfoLine(String line, NtpServerInfo ntpServerInfo) {
        this._debug.finest("Beginn der Verarbeitung der einzelnen Zeilen");
        String[] cols = null;
        Character z1 = Character.valueOf(line.charAt(0));
        line = line.substring(1);
        Pattern p = Pattern.compile("^|[\\s]+");
        cols = p.split(line);
        this._debug.finest("Abgetrenntes erstes Zeichen: " + z1 + ", restliche Zeile: " + line);
        switch (z1.charValue()) {
            case '*': {
                this._debug.finest("Aktueller Server (*) identifiziert");
                this._debug.finest("Ausgabespalten: remote: " + cols[0] + ", refid: " + cols[1] + ", st: " + cols[2] + ", when: " + cols[4] + ", reach: " + cols[6] + ", offset: " + cols[8] + ", jitter: " + cols[9]);
                ntpServerInfo.aktuellerZeitserver = cols[0];
                ntpServerInfo.vorhandeneZeitserver.add(cols[0] + "(*)");
                ntpServerInfo.refid = cols[1];
                ntpServerInfo.st = cols[2];
                ntpServerInfo.reach = cols[6];
                ntpServerInfo.offset = cols[8];
                ntpServerInfo.when = cols[4];
                ntpServerInfo.jitter = cols[9];
                this._debug.finest("Datenstruktur: aktueller Zeitserver: " + ntpServerInfo.aktuellerZeitserver + ", refid: " + ntpServerInfo.refid + ", st: " + ntpServerInfo.st + ", reach: " + ntpServerInfo.reach + ", offset: " + ntpServerInfo.offset + ", when: " + ntpServerInfo.when + ", jitter: " + ntpServerInfo.jitter);
                break;
            }
            case '+': {
                ntpServerInfo.vorhandeneZeitserver.add(cols[0] + "(+)");
                break;
            }
            case ' ': 
            case '-': {
                ntpServerInfo.vorhandeneZeitserver.add(cols[0] + "(-)");
            }
        }
        if (line.charAt(0) != '*' && !cols[4].equals("-") && !cols[8].equals("0.000")) {
            ntpServerInfo.ersatzZeitserver = cols[0];
            ntpServerInfo.ersatzOffset = cols[8] + "(" + cols[0] + ")";
        }
    }

    private synchronized Boolean mywait() {
        if (this.m_zyklusCount == this.m_zyklusCountMax) {
            this.set_shutDown();
            return this.m_shutDown == false;
        }
        ++this.m_zyklusCount;
        if (this.m_erstesMal.booleanValue()) {
            this.m_erstesMal = false;
            return this.m_shutDown == false;
        }
        try {
            this.wait(this.m_zyklusZeit * 1000L);
        }
        catch (InterruptedException e) {
            this._debug.warning("NTPinfoPoller.mywait: InterruptedException Caught");
        }
        catch (Exception e) {
            String errMess = "NTPinfoPoller.mywait: Exception Caught";
            errMess = errMess + "\n" + e.getMessage();
            this._debug.warning(errMess);
            e.printStackTrace();
        }
        return this.m_shutDown == false;
    }

    @Override
    public synchronized void run() {
        while (this.mywait().booleanValue()) {
            this.checkNewServerInfo();
        }
        System.out.println("Der Thread de.bsvrz.sys.dcf77.ntp.realclient.NTPinfoPoller wurde beendet!");
        System.out.println("Die ganze Applikation wird gestoppt!");
        System.exit(5);
    }

    public static void main(String[] args) {
        String[] cols;
        String line = "*alpha           .DCFa.           1 u    0   64  377    0.399   -1.49    0.617";
        line = line.substring(1);
        Pattern p = Pattern.compile("^|[\\s]+");
        for (String col : cols = p.split(line)) {
            System.out.println(col);
        }
    }

    class NtpServerInfo {
        String aktuellerZeitserver = "n/a";
        ArrayList<String> vorhandeneZeitserver = new ArrayList();
        String refid = new String();
        String st = new String();
        String t = new String();
        String when = new String();
        String poll = new String();
        String reach = new String();
        String delay = new String();
        String offset = "n/a";
        String jitter = new String();
        String ersatzZeitserver = null;
        String ersatzOffset = null;

        NtpServerInfo() {
        }

        public boolean equals(Object compObj) {
            if (this == compObj) {
                return true;
            }
            if (!(compObj instanceof NtpServerInfo)) {
                return false;
            }
            if (compObj == null || compObj.getClass() != this.getClass()) {
                return false;
            }
            NtpServerInfo that = (NtpServerInfo)compObj;
            return this.aktuellerZeitserver.equals(that.aktuellerZeitserver) && this.offset.equals(that.offset);
        }

        public boolean protAenderung(Object compObj) {
            if (this == compObj) {
                return false;
            }
            if (!(compObj instanceof NtpServerInfo)) {
                return true;
            }
            if (compObj == null || compObj.getClass() != this.getClass()) {
                return true;
            }
            NtpServerInfo that = (NtpServerInfo)compObj;
            boolean schwellPruefung = false;
            if (NTPinfoPoller.this.m_oschwelle < 0L) {
                schwellPruefung = true;
            }
            try {
                Float myoffset = new Float(this.offset);
                if (Math.abs(myoffset.floatValue()) > (float)NTPinfoPoller.this.m_oschwelle) {
                    schwellPruefung = true;
                }
                if (Math.abs((myoffset = new Float(that.offset)).floatValue()) > (float)NTPinfoPoller.this.m_oschwelle) {
                    schwellPruefung = true;
                }
            }
            catch (Exception e) {
                schwellPruefung = true;
            }
            return !this.aktuellerZeitserver.equals(that.aktuellerZeitserver) || !this.offset.equals(that.offset) && schwellPruefung;
        }

        public void aus(String titel) {
            System.out.println("");
            System.out.println("------- " + titel + " ---------------------------------");
            System.out.println("AktuellerZeitServer=" + this.aktuellerZeitserver);
            System.out.println("VorhandeneZeitServer:");
            if (this.vorhandeneZeitserver != null) {
                for (String vorhandenerZeitserver : this.vorhandeneZeitserver) {
                    System.out.println("     " + vorhandenerZeitserver);
                }
            }
            System.out.println("refid=" + this.refid);
            System.out.println("poll=" + this.poll);
            System.out.println("offset=" + this.offset);
            System.out.println("when=" + this.when);
            System.out.println("");
        }
    }
}

