/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.ntp.realclient;

import de.bsvrz.sys.dcf77.lib.ArgumentParser;
import de.bsvrz.sys.dcf77.ntp.realclient.NTPinfoPoller;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.IntpTrigger;
import java.util.HashMap;

public class RealNTPClient
implements IntpAllgemein {
    private DataAspZustand m_aktuellerZustand = new DataAspZustand();
    private IntpTrigger m_ntpTrigger = null;
    private NTPinfoPoller m_NTPinfoPoller = null;

    public RealNTPClient() {
        this.initKonstruktor("");
    }

    public RealNTPClient(String argString) {
        this.initKonstruktor(argString);
    }

    private void initKonstruktor(String argString) {
        HashMap<String, String> schluesselWertPaare = ArgumentParser.parseArgString(argString, "---");
        String cmd = ArgumentParser.getWert(schluesselWertPaare, "cmd", false, false);
        String zyklusZeitc = ArgumentParser.getWert(schluesselWertPaare, "zyklusZeit", false, false);
        String maxZyklenc = ArgumentParser.getWert(schluesselWertPaare, "maxZyklen", false, false);
        String oschwellec = ArgumentParser.getWert(schluesselWertPaare, "oschwelle", false, false);
        if (cmd == null) {
            cmd = new String("/usr/sbin/ntpq -p");
        }
        if (zyklusZeitc == null) {
            zyklusZeitc = "60";
        }
        if (maxZyklenc == null) {
            maxZyklenc = "-1";
        }
        if (oschwellec == null) {
            oschwellec = "-1";
        }
        long zyklusZeit = Long.parseLong(zyklusZeitc.trim());
        long maxZyklen = Long.parseLong(maxZyklenc.trim());
        long oschwelle = Long.parseLong(oschwellec.trim());
        NTPinfoPoller infoPoller = new NTPinfoPoller(cmd, this, zyklusZeit, maxZyklen, oschwelle);
        infoPoller.start();
        this.m_NTPinfoPoller = infoPoller;
        System.out.println("Instanz RealNTPClient initialisiert \ncmd=" + cmd + " ,zyklusZeit=" + zyklusZeit + " ,maxZyklen=" + maxZyklen);
    }

    @Override
    public String getAktuellerZeitServer() {
        return this.m_aktuellerZustand.aktuellerZeitserver;
    }

    @Override
    public String getZeitKorrektur() {
        return this.m_aktuellerZustand.letzteKorrekturZeit;
    }

    @Override
    public String[] getVorhandeneZeitServer() {
        return this.m_aktuellerZustand.vorhandeneZeitserver;
    }

    @Override
    public void setInstance(IntpTrigger ntpTrigger) {
        this.m_ntpTrigger = ntpTrigger;
    }

    public void beenden() {
        this.m_NTPinfoPoller.interrupt();
        this.m_NTPinfoPoller.set_shutDown();
    }

    public void setAktuellerZustand(DataAspZustand aktuellerZustand, Boolean wakeSenderThread) {
        this.m_aktuellerZustand = aktuellerZustand;
        aktuellerZustand.aus("RealNtpClient");
        if (wakeSenderThread.booleanValue() && this.m_ntpTrigger != null) {
            this.m_ntpTrigger.setTrigger();
        }
    }

    public void setAktuellerZustand(DataAspZustand aktuellerZustand) {
        this.setAktuellerZustand(aktuellerZustand, false);
    }

    public static void main(String[] args) {
        RealNTPClient realNTPClient2 = new RealNTPClient();
        System.out.println(realNTPClient2);
    }
}

