/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.zeitverw;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObjectType;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IdcfTestReader;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.net.InetAddress;
import java.util.Date;
import java.util.List;

public class DCFdav
implements StandardApplication,
ClientReceiverInterface,
ClientSenderInterface,
IdcfTestReader {
    private Debug _debug = Debug.getLogger();
    private ClientDavInterface m_davConnection = null;
    private SystemObject m_davRechner;
    private AttributeGroup m_atgDcfStatus;
    private Aspect m_aspZustand;
    private DataDescription m_dd_aspZustand;
    private String m_pidRechner = null;
    private DataAspZustand m_gelesenerDataAspZustand;
    private Boolean m_neuerZustand = false;
    Boolean m_isSubscribedSendDavZustand = false;
    Boolean m_isSubscribedReceiverDavZustand = false;

    public DCFdav(String[] args) {
        StandardApplicationRunner.run((StandardApplication)this, (String[])args);
    }

    public void initialize(ClientDavInterface davConnection) throws Exception {
        this.init(davConnection);
    }

    public void parseArguments(ArgumentList argumentList) throws Exception {
        try {
            this.m_pidRechner = argumentList.fetchArgument("-rechner").asNonEmptyString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        argumentList.fetchUnusedArguments();
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        return false;
    }

    public void update(ResultData[] results) {
        this.myupdate(results);
        System.out.println("DAV: update gerufen()");
    }

    @Override
    public DataAspZustand getNeuestenAspZustand() {
        DataAspZustand zustand = null;
        if (this.m_neuerZustand.booleanValue()) {
            zustand = this.m_gelesenerDataAspZustand;
        }
        this.m_neuerZustand = false;
        return zustand;
    }

    @Override
    public void closeDCFtestReader() {
        this.unsubscribeReceiveDavZustand();
    }

    @Override
    public void openDCFtestReader() {
        this.subscribeReceiveDavZustand();
    }

    private void init(ClientDavInterface davConnection) {
        this.m_davConnection = davConnection;
        if (this.m_pidRechner == null || this.m_pidRechner == "") {
            this.m_pidRechner = this.leseLokaleRechnerPid();
        }
        this.m_davRechner = davConnection.getDataModel().getObject(this.m_pidRechner);
        if (this.m_davRechner == null) {
            String errMess = this.getClass().getName();
            errMess = errMess + "davConnection.getDataModel().getObject( " + this.m_pidRechner + ") liefert null. Applikation wird beendet.";
            this._debug.error(errMess);
            System.exit(-5);
        }
        System.out.println("rechner" + this.m_davRechner);
        this.m_atgDcfStatus = davConnection.getDataModel().getAttributeGroup("atg.dcfStatus");
        System.out.println("m_atgDcfStatus" + this.m_atgDcfStatus);
        this.m_aspZustand = davConnection.getDataModel().getAspect("asp.zustand");
        System.out.println("m_aspZustand" + this.m_aspZustand);
        this.m_dd_aspZustand = new DataDescription(this.m_atgDcfStatus, this.m_aspZustand);
        System.out.println("m_dd_aspZustand" + this.m_dd_aspZustand);
    }

    public void subscribeSendDavZustand() {
        try {
            this.m_davConnection.subscribeSender((ClientSenderInterface)this, this.m_davRechner, this.m_dd_aspZustand, SenderRole.source());
        }
        catch (Exception e) {
            String errMess = "Fehler bei DCFdav.subscribeSendDavZustand() ";
            errMess = errMess + "\n" + e.getMessage();
            e.printStackTrace();
            System.err.println(errMess);
            return;
        }
        this.m_isSubscribedSendDavZustand = true;
        String mess = "Als Quelle des Aspekts rechner.dcfStatus.zustand angemeldet.";
        System.out.println(mess);
    }

    public void unsubscribeSendDavZustand() {
        try {
            this.m_davConnection.unsubscribeSender((ClientSenderInterface)this, this.m_davRechner, this.m_dd_aspZustand);
        }
        catch (Exception e) {
            System.out.println("Fehler bei DCFdav.unsubscribeSendDavZustand() " + e.getMessage());
            e.printStackTrace();
            return;
        }
        System.out.println("Abgemeldet.");
    }

    public void sendDavZustand(DataAspZustand dataAspZustand) {
        Data d1 = this.m_davConnection.createData(this.m_atgDcfStatus);
        d1.getTextValue("AktuellerZeitServer").setText(dataAspZustand.aktuellerZeitserver);
        d1.getArray("VorhandeneZeitServer").setLength(dataAspZustand.vorhandeneZeitserver.length);
        for (int i = 0; i < dataAspZustand.vorhandeneZeitserver.length; ++i) {
            if (dataAspZustand.vorhandeneZeitserver[i] != null) {
                d1.getArray("VorhandeneZeitServer").getItem(i).getTextValue("VorhandenerZeitServer").setText(dataAspZustand.vorhandeneZeitserver[i]);
            }
            d1.getTextValue("LetzteZeitKorrektur").setText(dataAspZustand.letzteKorrekturZeit);
        }
        ResultData rsd = new ResultData(this.m_davRechner, this.m_dd_aspZustand, new Date().getTime(), d1);
        try {
            this.m_davConnection.sendData(rsd);
        }
        catch (Exception e) {
            System.out.println("Fehler in DCFdav.sendDavZustand(), m_davConnection.sendData(rsd)");
            System.out.println(e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    public void subscribeReceiveDavZustand() {
        try {
            this.m_davConnection.subscribeReceiver((ClientReceiverInterface)this, this.m_davRechner, this.m_dd_aspZustand, ReceiveOptions.normal(), ReceiverRole.receiver());
        }
        catch (Exception e) {
            System.out.println("Fehler bei DCFdav.subscribeReceiveDavZustand() " + e.getMessage());
            e.printStackTrace();
            return;
        }
        this.m_isSubscribedReceiverDavZustand = true;
        System.out.println("Als Empfaenger des Aspekts rechner.dcfStatus.zustand angemeldet.");
    }

    public void unsubscribeReceiveDavZustand() {
        try {
            this.m_davConnection.unsubscribeReceiver((ClientReceiverInterface)this, this.m_davRechner, this.m_dd_aspZustand);
        }
        catch (Exception e) {
            System.out.println("Fehler bei DCFdav.unsubscribeReceiveDavZustand() " + e.getMessage());
            e.printStackTrace();
            return;
        }
    }

    private void myupdate(ResultData[] resultData) {
        DataAspZustand dataAspZustand = new DataAspZustand();
        for (int i = 0; i < resultData.length; ++i) {
            ResultData data = resultData[i];
            if (!data.getDataDescription().getAttributeGroup().getPid().equals("atg.dcfStatus") || !data.hasData()) continue;
            dataAspZustand.aktuellerZeitserver = data.getData().getTextValue("AktuellerZeitServer").getValueText();
            int arrLength = data.getData().getArray("VorhandeneZeitServer").getLength();
            dataAspZustand.vorhandeneZeitserver = new String[arrLength];
            for (int j = 0; j < arrLength; ++j) {
                dataAspZustand.vorhandeneZeitserver[j] = data.getData().getArray("VorhandeneZeitServer").getItem(j).getTextValue("VorhandenerZeitServer").getText();
            }
            dataAspZustand.letzteKorrekturZeit = data.getData().getTextValue("LetzteZeitKorrektur").getText();
            dataAspZustand.aus("Automatisch Empfangen");
            this.m_gelesenerDataAspZustand = dataAspZustand;
            this.m_neuerZustand = true;
        }
    }

    public void disconnect() {
        if (this.m_isSubscribedReceiverDavZustand.booleanValue()) {
            this.unsubscribeReceiveDavZustand();
        }
        if (this.m_isSubscribedSendDavZustand.booleanValue()) {
            this.unsubscribeSendDavZustand();
        }
        this.m_davConnection.disconnect(false, "");
    }

    public static void main(String[] args) {
        DCFdav dcfDav = new DCFdav(args);
        dcfDav.subscribeSendDavZustand();
        dcfDav.subscribeSendDavZustand();
    }

    public String leseLokaleRechnerPid() {
        String rechnerPid = "";
        String tcpip_lokal = "";
        String rechner_lokal = "";
        try {
            InetAddress thisInetAddress = InetAddress.getLocalHost();
            rechner_lokal = thisInetAddress.getHostName();
            tcpip_lokal = thisInetAddress.getHostAddress();
        }
        catch (Exception e) {
            String errMess = "InetAddress.getLocalHost().getHostName() Fehler";
            errMess = errMess + "\n" + e.getMessage();
            this._debug.error(errMess);
            e.printStackTrace();
        }
        if (this.m_davConnection == null) {
            String errMess = "keine Verbindung zum DAV";
            this._debug.error(errMess);
            return null;
        }
        DataModel dataModel = this.m_davConnection.getDataModel();
        Object typeSysObj = null;
        typeSysObj = dataModel.getType("typ.rechner");
        if (typeSysObj == null) {
            String errMess = "typ.rechner unbekannt";
            this._debug.error(errMess);
            return null;
        }
        typeSysObj = typeSysObj.isConfigurating() ? (ConfigurationObjectType)typeSysObj : (DynamicObjectType)typeSysObj;
        List typobjekte = typeSysObj.getElements();
        for (SystemObject sysObj : typobjekte) {
            if (sysObj == null) continue;
            Data data = sysObj.getConfigurationData(dataModel.getAttributeGroup("atg.rechnerInformation"));
            if (data == null) {
                String errMess = "F\u00fcr Rechner <" + sysObj.getName() + "> ist Attributgruppe <atg.rechnerInformation> nicht definiert";
                this._debug.error(errMess);
                continue;
            }
            String tcpip_dav = data.getItem("TCPIP").valueToString();
            String rechner_dav = data.getItem("Name").valueToString();
            if (!tcpip_lokal.equalsIgnoreCase(tcpip_dav) && !rechner_lokal.equalsIgnoreCase(rechner_dav)) continue;
            rechnerPid = sysObj.getPid();
            break;
        }
        if (rechnerPid == "") {
            String errMess = "";
            errMess = errMess + "lokaler Rechner " + rechner_lokal + "(" + tcpip_lokal + ") nicht im DaV konfiguriert.";
            this._debug.error(errMess);
        }
        return rechnerPid;
    }
}

