/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.dcf77.zeitverw;

import de.bsvrz.sys.dcf77.lib.ArgumentParser;
import de.bsvrz.sys.dcf77.zeitverw.DCFdav;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IdcfTestReader;
import de.bsvrz.sys.dcf77.zeitverw.IdcfTester;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.SenderThread;
import de.bsvrz.sys.funclib.debug.Debug;
import java.lang.reflect.Constructor;
import java.util.HashMap;

public class Zeitverwaltung {
    private Debug _debug = Debug.getLogger();
    private long m_zyklusZeit;
    private String m_ntpKlasse;
    private String m_ntpKlassenParameter = null;
    private IntpAllgemein m_ntpAllgemein;
    private DCFdav m_dcfDAV;
    private IdcfTester m_dcfTester;
    private SenderThread m_SenderThread;

    public IntpAllgemein get_ntpAllgemein() {
        return this.m_ntpAllgemein;
    }

    public IdcfTestReader get_dcfTestReader() {
        return this.m_dcfDAV;
    }

    public IdcfTester get_dcfTester() {
        return this.m_dcfTester;
    }

    IntpAllgemein genNtpAllgemeinObject(String ntpKlasse) {
        IntpAllgemein ntpAllgemein = null;
        try {
            Object c;
            Class<?> clazz = Class.forName(ntpKlasse);
            if (this.m_ntpKlassenParameter != null) {
                try {
                    Class[] paramTypes = new Class[]{String.class};
                    Constructor<?> con = clazz.getConstructor(paramTypes);
                    c = con.newInstance(this.m_ntpKlassenParameter);
                }
                catch (Exception e) {
                    System.out.println("Fehler beim Instanziieren der Klasse " + ntpKlasse + "\n mit den Parametern: " + this.m_ntpKlassenParameter);
                    System.out.println(e.getMessage());
                    e.printStackTrace();
                    Constructor<?> con = clazz.getConstructor(new Class[0]);
                    c = con.newInstance(null);
                }
            } else {
                Constructor<?> con = clazz.getConstructor(new Class[0]);
                c = con.newInstance(null);
            }
            this.m_ntpAllgemein = ntpAllgemein = (IntpAllgemein)c;
            if (c instanceof IdcfTester) {
                this.m_dcfTester = (IdcfTester)c;
            }
        }
        catch (Exception e) {
            String errMess = "Fehler beim Instanzieren der Klasse " + ntpKlasse;
            errMess = errMess + "\n" + e.getMessage();
            e.printStackTrace();
            System.err.println(errMess);
            this._debug.error(errMess);
            System.exit(2);
        }
        return ntpAllgemein;
    }

    public void parseZeitverwArgumente(String[] args) {
        HashMap<String, String> schluesselWertPaare = ArgumentParser.parseArgStrings(args, "=");
        this.m_ntpKlasse = ArgumentParser.getWert(schluesselWertPaare, "-ntpKlasse", true, false);
        System.out.println("main: -ntpKlasse= " + this.m_ntpKlasse);
        String zz = ArgumentParser.getWert(schluesselWertPaare, "-zyklusZeit", true, false);
        this.m_zyklusZeit = Long.parseLong(zz);
        System.out.println("main: -zyklusZeit= " + this.m_zyklusZeit);
        this.m_ntpKlassenParameter = ArgumentParser.getWert(schluesselWertPaare, "-ntpKlassenParameter", false, false);
        System.out.println("main: -ntpKlassenpars= " + this.m_ntpKlassenParameter);
    }

    private void startSenderThread(IntpAllgemein ntpAllgemein, DCFdav dcfDAV, long zyklusZeit) {
        Thread.UncaughtExceptionHandler eh = new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                e.printStackTrace();
                System.exit(5);
            }
        };
        this.m_SenderThread = new SenderThread(ntpAllgemein, dcfDAV, zyklusZeit, -1L);
        this.m_SenderThread.setUncaughtExceptionHandler(eh);
        this.m_SenderThread.start();
    }

    public void init(String[] args) {
        DCFdav dcfDav;
        System.out.println("--------------------------------------------");
        for (String arg : args) {
            System.out.println(arg);
        }
        System.out.println("--------------------------------------------");
        Zeitverwaltung zeitverwaltung = this;
        String[] DAVargs = new String[args.length];
        if (args.length < 6) {
            String errMess = "Zeitverwaltung: zu wenig Parameter: ";
            this._debug.error(errMess);
            System.exit(-1);
        }
        System.arraycopy(args, 0, DAVargs, 0, DAVargs.length);
        zeitverwaltung.m_dcfDAV = dcfDav = new DCFdav(DAVargs);
        dcfDav.subscribeSendDavZustand();
        zeitverwaltung.parseZeitverwArgumente(args);
        IntpAllgemein ntpAllgemein = zeitverwaltung.genNtpAllgemeinObject(zeitverwaltung.m_ntpKlasse);
        DataAspZustand dataAspZustand = new DataAspZustand();
        dataAspZustand.aktuellerZeitserver = ntpAllgemein.getAktuellerZeitServer();
        dataAspZustand.vorhandeneZeitserver = ntpAllgemein.getVorhandeneZeitServer();
        dataAspZustand.letzteKorrekturZeit = ntpAllgemein.getZeitKorrektur();
        dataAspZustand.aus("vom NTP Server erzeugt");
        zeitverwaltung.startSenderThread(ntpAllgemein, zeitverwaltung.m_dcfDAV, zeitverwaltung.m_zyklusZeit);
        ntpAllgemein.setInstance(this.m_SenderThread);
    }

    public void reinit() {
        this.m_SenderThread.set_shutDown();
        this.m_SenderThread.interrupt();
        this.m_dcfDAV.disconnect();
    }

    public void dataRequest(Object object, Object dataDescription, byte state) {
    }

    public boolean isRequestSupported(Object object, Object dataDescription) {
        return false;
    }

    public void initialize(Object davConnection) throws Exception {
    }

    public void parseArguments(Object argumentList) throws Exception {
    }

    public static void main(String[] args) {
        Zeitverwaltung zeitverwaltung = new Zeitverwaltung();
        zeitverwaltung.init(args);
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("main beendet");
    }
}

