package de.bsvrz.sys.dcf77.ntp;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

import de.bsvrz.sys.dcf77.lib.UtlDateTime;
import de.bsvrz.sys.dcf77.zeitverw.DataAspZustand;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.IntpTrigger;
import de.bsvrz.sys.dcf77.zeitverw.Zeitverwaltung;

/**
 * Diese Klasse implementiert einen NTP Client zur formalen Prüfung der Zeitverwaltung.
 * Dieser Client implementiert das interface {@link IntpAllgemein} zur Verfuegung.
 * @author ChriestenJ
 *
 */

public class DefaultNtp2 implements IntpAllgemein
{
    private Timer timerObj = new Timer (true);
    String m_aktuellerZS = "n/a";

    /**
     * aktueller Aspekt "Recher.dcfStatus.Zustand"
     */
    private DataAspZustand m_aktuellerZustand = new DataAspZustand();

    /**
     * Schnittstellenobjekt um den Senderthread aufzuwecken
     */
    public IntpTrigger m_ntpTrigger;

    /**
     * Konstruktor
     * gibt Startmeldung auf der Console aus
     */
     public DefaultNtp2()
     {
       System.out.println("Objekt TestNtpServer initialisiert");
       //this.start();
       long pollingIntervall = 10100l;
       timerObj.schedule(new NtpStatusNotifier(), 0, pollingIntervall);
     }

    /**
     * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#getAktuellerZeitServer()
     */
    public String getAktuellerZeitServer()
    {
      return m_aktuellerZustand.aktuellerZeitserver;
    }

    /*
     * (non-Javadoc)
     * @see de.bsvrz.sys.dcf77_ausl.zeitverw.IntpAllgemein#getLetzteZeitKorrektur()
     */
    public String getZeitKorrektur()
    {
      return m_aktuellerZustand.letzteKorrekturZeit;
    }

    /*
     * (non-Javadoc)
     * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#getVorhandeneZeitServer()
     */
    public String[] getVorhandeneZeitServer()
    {
      return m_aktuellerZustand.vorhandeneZeitserver;
    }

    /*
     * (non-Javadoc)
     * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#setInstance(de.bsvrz.sys.dcf77.zeitverw.IntpTrigger)
     */
    public void setInstance( IntpTrigger ntpTrigger )
    {
      m_ntpTrigger = ntpTrigger;
    }

    /**
     * Setzt den aktuellen Zustand im Zeitserverclient. Dieser Zustand wird vom SenderThread der Zeitverwaltung
     * zyklisch gelesen.
     * @param aktuellerZustand Übergabe der aktuellen Zeitserverdaten als Objekt
     * @param wakeSenderThread Flag um den Senderthread Warte-Zyklus zu unterbrechen, default = false
     */
    public void setAktuellerZustand(DataAspZustand aktuellerZustand, Boolean wakeSenderThread)
    {
      m_aktuellerZustand = aktuellerZustand;

      if ( wakeSenderThread && (m_ntpTrigger != null) )
      {
        m_ntpTrigger.setTrigger();
        System.out.println("SenderThread geweckt.");
      }
    }

    /**
     * Stop program
     */
     public void stop()
     {
       timerObj.cancel();
     }

    /**
     * siehe setAktuellerZustand(DataAspZustand aktuellerZustand, Boolean wakeSenderThread)
     * @param aktuellerZustand Übergabe der aktuellen Zeitserverdaten als Objekt
     */
    public void setAktuellerZustand(DataAspZustand aktuellerZustand)
     {
       setAktuellerZustand(aktuellerZustand, false);
     }
    
    public void generiereZustand()
    {
      long aktuelleZeit = (new Date()).getTime();
      int minute = UtlDateTime.extractFieldValues(aktuelleZeit, Calendar.MINUTE);
      m_aktuellerZS = "ZEITSERVER_"+minute+"(*)";
      m_aktuellerZustand.aktuellerZeitserver = m_aktuellerZS; 
      int millis = UtlDateTime.extractFieldValues(aktuelleZeit, Calendar.MILLISECOND);
      System.out.println(millis);
      double millisD = (double)millis/1000;
      System.out.println(millisD);
      
      String[] vorZeits = new String[3];
      vorZeits[0] = m_aktuellerZS;
      vorZeits[1] = "ZEITSERVER_X";
      vorZeits[2] = "ZEITSERVER_Y";
      m_aktuellerZustand.vorhandeneZeitserver = vorZeits;

      Date today = new java.util.Date();
      SimpleDateFormat formatter =
        new SimpleDateFormat("dd.MM.yyyy, HH:mm:ss");
      String mydate = formatter.format( today );
      String letzteKorrekturZeit = mydate+","+millisD;
      m_aktuellerZustand.letzteKorrekturZeit = letzteKorrekturZeit;
      
      if ( (m_ntpTrigger != null) )
      {
        m_ntpTrigger.setTrigger();
      }
    }

    private class NtpStatusNotifier extends TimerTask
    {
      public void run()
      {
        // action
        generiereZustand();
        System.out.println("ACTION");
      }
  
      /**
      * Stop the file monitor polling.
      */
      public void stop()
      {
        timerObj.cancel();
      }
    }
    
    /**
      * Testroutine zum austesten des lokale Moduls
      * Wird fuer verschiedene Tests im Laufe des Entwicklungs- und Wartungsprozesses verwendet
      * 
      * @param args uebergebene Testargumente
      */
    public static void main( String[] args )
    {
      long aktuelleZeit = (new Date()).getTime();
      int minute = UtlDateTime.extractFieldValues(aktuelleZeit, Calendar.MINUTE);
      int millis = UtlDateTime.extractFieldValues(aktuelleZeit, Calendar.MILLISECOND);
      System.out.println(millis);
      double millisD = (double)millis/1000;
      System.out.println(millisD);
      if ( 1==1 ) return;

      Double x = (double)532/1000;
      System.out.println(x);
      if ( 1==1 ) return;

      DefaultNtp2 ntp = new DefaultNtp2();
      try
      {
        Thread.sleep( 30000 );
      }
      catch ( InterruptedException e )
      {
        // TODO Auto-generated catch block
        e.printStackTrace();
      }
      System.out.println("main beendet");
      if ( 1==1 ) return;
      
      String[] myargs = new String[7];
      // myargs[0]="-datenverteiler=192.168.1.34:8083";
      myargs[0]="-datenverteiler=localhost:8083";
      myargs[1]="-debugLevelStdErrText=FINE";
      myargs[2]="-benutzer=Tester";
      myargs[3]="-authentifizierung=C:\\Datenverteiler\\skripte-dosshell\\passwd";
      myargs[4]="-rechner=rechner.Rechner1";
      myargs[5]="-ntpKlasse=de.bsvrz.sys.dcf77Test.ntp.TestNtpServer";
      myargs[6]="-zyklusZeit=-1";
      
      //TesterNTP testerNTP = new TesterNTP(); 
      Zeitverwaltung zeitverwaltung = new Zeitverwaltung();
      zeitverwaltung.init( myargs );
    }
  }

