/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.sys.dcf77.zeitverw;

import java.util.Arrays;

/**
 * Hilfsklasse; definiert die Datentruktur zur Aufnahme des
 * Datenverteileraspekts "Recher.dcfStatus.Zustand".<br>
 * Der Aspekt wird in Instanzen dieser Behaelterklasse an den DAV geschickt und vom
 * gelesen.
 * 
 * @author ChriestenJ
 */

public class DataAspZustand
{
  //---------------------------------------------------------------------------
  // Membervariablen
  //---------------------------------------------------------------------------
    /**
     * Hier wird das Attribut "AktuellerZeitServer" gespeichert   
     */
    public String aktuellerZeitserver = null;

    /**
     * Hier wird das Attribut "VorhandeneZeitServer" gespeichert   
     */
    public String[] vorhandeneZeitserver = null;

    /**
     * Hier wird das Attribut "LetzteZeitKorrektur" gespeichert   
     */
    public String letzteKorrekturZeit = null;
  //---------------------------------------------------------------------------

  //---------------------------------------------------------------------------
  // Konstruktoren
  //---------------------------------------------------------------------------
    /**
     * Konstruktor1. Initialisiert die Klasse mit den uebergebenen Werten.
     *
     * @param aktuellerZeitserver Name Zeitserver
     * @param vorhandeneZeitserver Liste der vorhandenen Zeitserver
     * @param letzteKorrekturZeit Info letze Zeitkorrektur
     */
    public DataAspZustand(String aktuellerZeitserver, 
                          String[] vorhandeneZeitserver, 
                          String letzteKorrekturZeit)
    {
      this.aktuellerZeitserver = aktuellerZeitserver;
      this.vorhandeneZeitserver = vorhandeneZeitserver.clone(); 
      this.letzteKorrekturZeit = letzteKorrekturZeit;
    }

    /**
     * Konstruktor2. Initialisiert die Klasse mit leeren Werten.
     */
    public DataAspZustand() 
    {
      this.aktuellerZeitserver = "";
      this.vorhandeneZeitserver = new String[0]; 
      this.letzteKorrekturZeit = "";
    }
  //---------------------------------------------------------------------------
    
    /**
     * ueberschreibt die equals Methode
     * 
     * @param compObj Vergleichsobjekt
     * @return true (gleich) oder false (ungleich)
     */
    @Override 
    public boolean equals(Object compObj) 
    {
      if ( this == compObj ) return true;

      if ( !(compObj instanceof DataAspZustand) ) return false;
      //Alternative to the above line :
      if ( compObj == null || compObj.getClass() != this.getClass() ) return false;

      //cast to native object is now safe
      DataAspZustand that = (DataAspZustand)compObj;

      if ( (this.aktuellerZeitserver == null) || (that.aktuellerZeitserver == null) )
        return false;
      
      return
        this.aktuellerZeitserver.equals( that.aktuellerZeitserver) &&
        Arrays.equals( this.vorhandeneZeitserver, that.vorhandeneZeitserver ) &&
        this.letzteKorrekturZeit.equals( that.letzteKorrekturZeit);
    }

  // -----------------------------------------------------------------------------------------  

    /**
     * Kopiert die uebergebenen Quell Einzelkomponenten auf eine Instanz Variable.
     * 
     * @param aktuellerZeitserver Komponente "AktuellerZeitServer"
     * @param vorhandeneZeitserver Komponente "VorhandeneZeitServer"
     * @param letzteKorrekturZeit Komponente "LetzteZeitKorrektur"
     * @return Zielobjekt vom Type DataAspZustand
     */
    public DataAspZustand copy(String aktuellerZeitserver, 
                               String[] vorhandeneZeitserver, 
                               String letzteKorrekturZeit)
    {
      this.aktuellerZeitserver = aktuellerZeitserver;
      if ( vorhandeneZeitserver == null )
      {
        this.vorhandeneZeitserver = null;
      }
      else
      {  
        this.vorhandeneZeitserver = vorhandeneZeitserver.clone(); 
      }
      this.letzteKorrekturZeit = letzteKorrekturZeit;

      return(this);
    }

    /**
     * Kopiert die uebergebenen Quell Instanz auf das aktuelle Objekt.
     *
     * @param quellObj quell Objekt vom Type DataAspZustand 
     * @return Zielobjekt vom Type DataAspZustand
     */
    public DataAspZustand copy(DataAspZustand quellObj)
    {
      this.copy(quellObj.aktuellerZeitserver, quellObj.vorhandeneZeitserver, quellObj.letzteKorrekturZeit);
      return(this);
    }
    
    
  /**
   * Ausgabefunktion. Schreibt die aktuellen Objektdaten auf die Konsole.
   * 
   * @param titel Ueberschrift der Testausgabe
   */
  public void aus(String titel)
  {
    System.out.println("");
    System.out.println("------- " + titel + " ---------------------------------");
    System.out.println("AktuellerZeitServer="+aktuellerZeitserver);

    System.out.println("VorhandeneZeitServer:");
    if ( vorhandeneZeitserver != null )
    {
      for (int i = 0; i < vorhandeneZeitserver.length; i++)
      {
        System.out.println("     VorhandenerZeitServer["+i+"]="+vorhandeneZeitserver[i]);
      }
    }
    
    System.out.println("LetzteZeitKorrektur="+letzteKorrekturZeit);
    System.out.println("--------------------------------------------");
    System.out.println("");
  }

  /**
   * siehe {@link #aus(String)}. titel wird mit "" versorgt.
   * 
   */
  public void aus()
  {
    this.aus("");
  }  
  // -----------------------------------------------------------------------------------------  

  /**
   * Testroutine fuer das lokale Modul.
   * Wird fuer verschiedene Tests im Laufe des Entwicklungs- und Wartungsprozesses verwendet
   * 
   * @param args Testargumente
   */
  public static void main( String[] args )
  {
    String[] vorhandeneZeitserver = new String[3];
    vorhandeneZeitserver[0] = "vorh0";
    vorhandeneZeitserver[1] = "vorh1";
    DataAspZustand m_aktuellerZustand = new DataAspZustand("aktuellerZS", 
                                            vorhandeneZeitserver,
                                            "14:00:47, n/a");
    m_aktuellerZustand.aus();
    
//    String a[] = {"aa", "bb", "cc"};
//    String b[] = {"aa", "bb", "cc"};
//    String c[] = {"a1", "a2", "a3"};
//    String d[] = null;
//    zu1 = new DataAspZustand( "111", a, "222" );
//    zu1.aus("zu1");
//
//    zu2 = new DataAspZustand();
//    zu2.copy( "bb", a, "cc" );
//    zu2.aus("zu2");
    
    //System.out.println("d0="+d[0] +" d1="+d[1] + "d2="+d[2]);
  }  
}
