/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.sys.dcf77.zeitverw;

/**
 * Interface zur Anbindung eines NTP (Zeitserver) Dienstes.
 * Der eingebundene Zeitserverclient muss dieses Interface zur Verfügung stellen.
 *
 * @author ChriestenJ
 */

public interface IntpAllgemein
{
  /**
   * Liefert den Namen des aktuellen Zeitserver
   * @return aktueller Zeitserver: Rechnername, IP Addresse (z.B. z.B. 172.16.3.103) oder n/a (nicht ermittelbar)
   */
  public abstract String getAktuellerZeitServer();

  /**
   * Liefert die Namen der vorhandenen Zeitserver
   * @return String Liste mit Namen,
   * mögliche Formate: Rechnername, IP Addresse oder n/a (nicht ermittelbar)
   */
  public abstract String[] getVorhandeneZeitServer();

  /**
   * Liefert Zeitkorrektur mit Zeitstempel und Korrekturzeit
   * in Millisekunden.
   * @return String Zeitkorrektur, n/a (keine Korrektur seit letzter Abfrage) 
   * oder "Datum, Uhrzeit, Korrektur in Millisekunden" (z.B.
   * 01.06.2007, 12:54:35, n/a, 01.06.2007, 12:54:35, 886)
   */
  public abstract String getZeitKorrektur();


  /**
   * Methode mit der die Klasse, die das Interface 
   * implementiert die Instanz der rufende Klasse mitgeteilt wird. 
   * Die Interface-implentierende Klasse kann dann ihrerseits auf
   * die Schnittstellen der rufende Klasse zugreifen.
   * 
   * @param ntpTrigger Instanz der Triggerklasse
   * ntpTrigger.setTrigger() unterbricht den Wartezyklus des SenderThreads
   */
  public abstract void setInstance (IntpTrigger ntpTrigger);
}
