/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.sys.dcf77.zeitverw;

/**
 * Interface zum Aufwecken des SenderThreads der Zeitverwaltung. 
 * Ein eingebunder NTP Client kann den SenderThread ueber die Methode des Interfaces 
 * dazu veranlassen den Wartzyklus vorzeitig zu beenden und sofort zu senden.<br>
 * Das Interfaceobjekt wird nach der Instanziierung der NTP Klasse 
 * mittels IntpAllgemein.setInstance uebergeben.
 * 
 * @author ChriestenJ
 */
public interface IntpTrigger
{
  /**
   * Methode zum Auslösen eines Triggers, der das sofortige Bearbeiten der
   * Daten des NTP (Zeitserver) - Dienstes auslöst.
   * Ansonsten werden die Daten "nur" zyklisch ausgewertet.
   */
  public abstract void setTrigger();
}
