/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.sys.dcf77.ntp;

import java.util.Date;

import de.bsvrz.sys.dcf77.lib.UtlDateTime;
import de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein;
import de.bsvrz.sys.dcf77.zeitverw.IntpTrigger;



/**
 * Klasse mit Dummy-NTP-Server; sie implementiert das Interface {@link IntpAllgemein}.
 *  
 * Alle get-Methoden werden in dieser Klasse mit einem default - Wert belegt.
 * Für die Realisierung der Anbindung eines konkreten NTP Servers gibt es folgende
 * Möglichkeiten:<br>
 * 1. Erstellen einer Klasse die das Interface IntpAllgemein implementiert <br>
 * 2. Ableiten von Klasse DefaultNTP und überschreiben der Interface Funktionen<br><br>
 *
 * Dieser Dummy-NTP-Server kann für einen ersten Grobtest der Zeitverwaltung verwendet werden.
 * Bei jeder dritten Anfrage des Zeitserver Sender Threads wird der Name des aktuellen Zeitservers geaendert.
 * Diese Aenderungen werden im DAV archiviert.
 *
 * @author ChriestenJ
 *
 */

public class DefaultNtp implements IntpAllgemein
{
  /**
   * Schnittstellenobjekt um den Senderthread aufzuwecken
   */
  private IntpTrigger m_ntpTrigger;

  // Fuer Tests
  private String m_aktuellerZeitserver = "Servakt_";
  private int m_counter = 0;



 /**
  * Konstruktor
  */
  public DefaultNtp()
  {
    System.out.println("Objekt DefaultNtp initialisiert");
  }

  /*
   * (non-Javadoc)
   * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#getAktuellerZeitServer()
   */
  public String getAktuellerZeitServer()
  {
    if ( (m_counter % 3) == 0 )
      m_aktuellerZeitserver = "akt_"+m_counter;
    if ( (m_ntpTrigger != null ) && ((m_counter % 10) == 0) )
    { // Trigger auslösen
      m_ntpTrigger.setTrigger();
    }
    m_counter = m_counter + 1;
    return m_aktuellerZeitserver;
  }

  /*
   * (non-Javadoc)
   * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#getLetzteZeitKorrektur()
   */
  public String getZeitKorrektur()
  {
    // dummy, aktuelle Zeit
    String zeitk = UtlDateTime.date2String(new Date(), "dd.MM.yyyy HH:mm:ss,SSS");
    return zeitk;
  }

  /*
   * (non-Javadoc)
   * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#getVorhandeneZeitServer()
   */
  public String[] getVorhandeneZeitServer()
  {
    String[] vorhandeneZeitServer = new String[4];

    if ( m_aktuellerZeitserver != null )
      vorhandeneZeitServer[0] = m_aktuellerZeitserver;
    else
      vorhandeneZeitServer[0] = "n/a";

    vorhandeneZeitServer[1] = "vorhanden1";
    vorhandeneZeitServer[2] = "vorhanden2";
    vorhandeneZeitServer[3] = "vorhanden3";
    
    return vorhandeneZeitServer;
  }

  /*
   * (non-Javadoc)
   * @see de.bsvrz.sys.dcf77.zeitverw.IntpAllgemein#setInstance(de.bsvrz.sys.dcf77.zeitverw.IntpTrigger)
   */
  public void setInstance( IntpTrigger ntpTrigger )
  {
    m_ntpTrigger = ntpTrigger;
  }

  /**
   * Testroutine fuer das lokale Modul.
   * Wird fuer verschiedene Tests im Laufe des Entwicklungs- und Wartungsprozesses verwendet.
   * 
   * @param args Testargumente
   */
  public static void main( String[] args )
  {
    return;
  }

}

