package de.bsvrz.sys.dcf77.zeitverw;


import java.net.InetAddress;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.ConfigurationObjectType;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.DynamicObjectType;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.application.StandardApplication;
import de.bsvrz.sys.funclib.application.StandardApplicationRunner;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;

/**
 * Hilfsklasse; implementiert die gesamte DAV Funktionalität der SWE DCF77. Hierzu gehören der Verbindungsafbau zum DAV, das an- und abmelden der Quellen und
 * Empfaenger, sowie das senden und empfangen des Aspekts "Recher.dfcStatus.Zustand".
 *
 * @author ChriestenJ
 */

public class DCFdav implements StandardApplication, ClientReceiverInterface, ClientSenderInterface,
    IdcfTestReader
{

  // ---------------------------------------------------------------------------
  // Membervariablen
  // ---------------------------------------------------------------------------
  private Debug _debug = Debug.getLogger();

  /**
   * Aktuelle Verbindung zum Datenverteiler.
   */
  private ClientDavInterface m_davConnection = null;

  /**
   * Hilfsvariable zur Identifiaktion der DAV Daten (SystemObjekt).
   */
  private SystemObject m_davRechner;

  /**
   * Hilfsvariable zur Identifiaktion der DAV Daten (Attributgruppe).
   */
  private AttributeGroup m_atgDcfStatus;

  /**
   * Hilfsvariable zur Identifiaktion der DAV Daten (Aspekt).
   */
  private Aspect m_aspZustand;

  /**
   * Beschreibung der DAV Daten (DataDescription Aspekt Zustand).
   */
  private DataDescription m_dd_aspZustand;

  /**
   * Pid des verwendeten Rechnerobjekts
   */
  private String m_pidRechner = null;

  // lokale Hilfsvariablen
  // Fuer JUNIT Test: Der letzte vom Datenverteiler empfangene zustand
  // und Flag, ob bereits ausgewertet
  /**
   * fuer IdcfTester: Inhalt des letzen gelesenen DAV Zustands.
   */
  private DataAspZustand m_gelesenerDataAspZustand;

  /**
   * fuer IdcfTester: wurde seit dem letzten lesen ein neuer Zustand empfangen?
   */
  private Boolean m_neuerZustand = false;

  // sind Sender bzw. Empfaenger am Datenverteiler angemeldet?
  Boolean m_isSubscribedSendDavZustand = false;

  Boolean m_isSubscribedReceiverDavZustand = false;

  // ---------------------------------------------------------------------------
  // Konstruktoren
  // ---------------------------------------------------------------------------

  /**
   * @param args
   *          notwendige Argumente zur Datenverteilerverbindung
   * @see de.bsvrz.sys.dcf77.zeitverw.Zeitverwaltung#main(String[])
   */
  public DCFdav( String[] args )
  {
    StandardApplicationRunner.run( this, args );
  }

  // -------------------------------------------------------------
  // Interface Methods StandardApplication
  // -------------------------------------------------------------

  /*
   * (non-Javadoc)
   *
   * @see sys.funclib.application.StandardApplication#initialize(stauma.dav.clientside.ClientDavInterface)
   */
  public void initialize( ClientDavInterface davConnection ) throws Exception
  {
    // DAV Objekte initialisieren
    init( davConnection );
    // subscribeReceiveDavZustand();

    // subscribeSendDavZustand();
  }

  /*
   * (non-Javadoc)
   *
   * @see sys.funclib.application.StandardApplication#parseArguments(sys.funclib.ArgumentList)
   */
  public void parseArguments( ArgumentList argumentList ) throws Exception
  {
    // optionale Argumente
    try
    {
      m_pidRechner = argumentList.fetchArgument( "-rechner" ).asNonEmptyString();
    }
    catch ( IllegalArgumentException e )
    {
    }

    // restliche Argumente überlesen -> Vermeidung von Fehlern
    argumentList.fetchUnusedArguments();

//    try
//    {
//      String wegwerfen = argumentList.fetchArgument( "-ntpKlasse" ).asNonEmptyString();
//      wegwerfen = argumentList.fetchArgument( "-zyklusZeit" ).asNonEmptyString();
//      wegwerfen = argumentList.fetchArgument( "-ntpKlassenParameter" ).asNonEmptyString();
//    }
//    catch ( IllegalArgumentException e )
//    {
//    }
  }

  // -------------------------------------------------------------

  // ------------------------------------------------------------------
  // Methods to satisfy Interface ClientSenderInterface
  // ------------------------------------------------------------------

  /*
   * (non-Javadoc)
   *
   * @see stauma.dav.clientside.ClientSenderInterface#dataRequest(stauma.dav.configuration.interfaces.SystemObject, stauma.dav.clientside.DataDescription, byte)
   */
  public void dataRequest( SystemObject object, DataDescription dataDescription, byte state )
  {
  }

  /*
   * (non-Javadoc)
   *
   * @see stauma.dav.clientside.ClientSenderInterface#isRequestSupported(stauma.dav.configuration.interfaces.SystemObject,
   *      stauma.dav.clientside.DataDescription)
   */

  public boolean isRequestSupported( SystemObject object, DataDescription dataDescription )
  {
    return false;
  }

  // ------------------------------------------------------------------

  // ------------------------------------------------------------------
  // Methods to satisfy Interface ClientReceiverInterface
  // ------------------------------------------------------------------

  /*
   * (non-Javadoc)
   *
   * @see stauma.dav.clientside.ClientReceiverInterface#update(stauma.dav.clientside.ResultData[])
   */
  public void update( ResultData[] results )
  {
    myupdate( results );
    System.out.println( "DAV: update gerufen()" );
  }

  // ------------------------------------------------------------------

  // ------------------------------------------------------------------
  // Methods to satisfy Interface IdfcTestReader
  // ------------------------------------------------------------------

  /*
   * (non-Javadoc)
   *
   * @see de.bsvrz.sys.dfctest.zeitverw.IdcfTestReader#getNeuestenAspZustand()
   */
  public DataAspZustand getNeuestenAspZustand()
  {
    DataAspZustand zustand = null;
    if ( m_neuerZustand )
      zustand = m_gelesenerDataAspZustand;

    m_neuerZustand = false;
    return (zustand);
  }

  /*
   * (non-Javadoc)
   *
   * @see de.bsvrz.sys.dfctest.zeitverw.IdcfTestReader#closeDCFtestReader()
   */
  public void closeDCFtestReader()
  {
    unsubscribeReceiveDavZustand();
  }

  /*
   * (non-Javadoc)
   *
   * @see de.bsvrz.sys.dfctest.zeitverw.IdcfTestReader#openDCFtestReader()
   */
  public void openDCFtestReader()
  {
    subscribeReceiveDavZustand();
  }

  // -------------------------------------------------------------

  /**
   * Initialisiert Datenverteilerspezifische Membervariabelen
   *
   * @param davConnection
   *          aktuelle Verbindung zum Datenverteiler
   */
  private void init( ClientDavInterface davConnection )
  {
    m_davConnection = davConnection;

    if ( (m_pidRechner == null) || (m_pidRechner == "") )
      m_pidRechner = leseLokaleRechnerPid();

    // Bestandteile der Datenidentifikation
    m_davRechner = davConnection.getDataModel().getObject( m_pidRechner );
    if ( m_davRechner == null )
    {
      String errMess = this.getClass().getName();
      errMess += "davConnection.getDataModel().getObject( " + m_pidRechner + ") liefert null. Applikation wird beendet.";
      _debug.error( errMess );
      System.exit( -5 );
    }

    System.out.println( "rechner" + m_davRechner );
    m_atgDcfStatus = (AttributeGroup) davConnection.getDataModel().getAttributeGroup(
        "atg.dcfStatus" );
    System.out.println( "m_atgDcfStatus" + m_atgDcfStatus );
    m_aspZustand = (Aspect) davConnection.getDataModel().getAspect( "asp.zustand" );
    System.out.println( "m_aspZustand" + m_aspZustand );

    m_dd_aspZustand = new DataDescription( m_atgDcfStatus, m_aspZustand );
    System.out.println( "m_dd_aspZustand" + m_dd_aspZustand );
  }

  /**
   * Anmeldung am DAV als Quelle der Attributgruppe rechner.dcfStatus.zustand
   */
  public void subscribeSendDavZustand()
  {
    try
    {
      m_davConnection.subscribeSender( (ClientSenderInterface) this, m_davRechner, m_dd_aspZustand,
      SenderRole.source() );
    }
    catch ( Exception e )
    {
      String errMess = "Fehler bei DCFdav.subscribeSendDavZustand() ";
      errMess += "\n" + e.getMessage();
      e.printStackTrace();
      System.err.println( errMess );
      return;
    }

    m_isSubscribedSendDavZustand = true;
    String mess = "Als Quelle des Aspekts rechner.dcfStatus.zustand angemeldet.";
    System.out.println( mess );
  }

  /**
   * Abmeldung als Sender/Quelle der Attributgruppe rechner.dcfStatus.zustand
   */
  public void unsubscribeSendDavZustand()
  {
    try
    {
      m_davConnection.unsubscribeSender( (ClientSenderInterface) this, m_davRechner,
          m_dd_aspZustand );
    }
    catch ( Exception e )
    {
      System.out.println( "Fehler bei DCFdav.unsubscribeSendDavZustand() " + e.getMessage() );
      e.printStackTrace();
      return;
    }

    System.out.println( "Abgemeldet." );
  }

  /**
   * Sende Datensatz vom Type rechner.dcfStatus.zustand
   *
   * @param dataAspZustand
   *          Versandobjekt
   */
  public void sendDavZustand( DataAspZustand dataAspZustand )
  {
    // Fuelle ResultData fuer asp.Zustand
    // ------------------------------------------------------------------
    Data d1 = m_davConnection.createData( m_atgDcfStatus );
    d1.getTextValue( "AktuellerZeitServer" ).setText( dataAspZustand.aktuellerZeitserver );

    d1.getArray( "VorhandeneZeitServer" ).setLength( dataAspZustand.vorhandeneZeitserver.length );
    for (int i = 0; i < dataAspZustand.vorhandeneZeitserver.length; i++)
    {
      if ( dataAspZustand.vorhandeneZeitserver[i] != null )
      {
        d1.getArray( "VorhandeneZeitServer" ).getItem( i ).getTextValue( "VorhandenerZeitServer" )
            .setText( dataAspZustand.vorhandeneZeitserver[i] );
      }

      d1.getTextValue( "LetzteZeitKorrektur" ).setText( dataAspZustand.letzteKorrekturZeit );
    }
    // ------------------------------------------------------------------

    ResultData rsd = new ResultData( m_davRechner, m_dd_aspZustand, new Date().getTime(), d1 );
    try
    {
      m_davConnection.sendData( rsd );
    }
    catch ( Exception e )
    {
      System.out.println( "Fehler in DCFdav.sendDavZustand(), m_davConnection.sendData(rsd)" );
      System.out.println( e.getMessage() );
      e.printStackTrace();
      return;
    }

    return;
  }

  /**
   * Anmeldung am DAV als Empfaenger der Attributgruppe rechner.dcfStatus.zustand
   */
  public void subscribeReceiveDavZustand()
  {
    try
    {
      m_davConnection.subscribeReceiver( (ClientReceiverInterface) this, m_davRechner,
          m_dd_aspZustand, ReceiveOptions.normal(), ReceiverRole.receiver() );
    }
    catch ( Exception e )
    {
      System.out.println( "Fehler bei DCFdav.subscribeReceiveDavZustand() " + e.getMessage() );
      e.printStackTrace();
      return;
    }

    m_isSubscribedReceiverDavZustand = true;
    System.out.println( "Als Empfaenger des Aspekts rechner.dcfStatus.zustand angemeldet." );
  }

  /**
   * Abmeldung als Empfaenger/Senke der Attributgruppe rechner.dcfStatus.zustand
   */
  public void unsubscribeReceiveDavZustand()
  {
    try
    {
      m_davConnection.unsubscribeReceiver( (ClientReceiverInterface) this, m_davRechner,
          m_dd_aspZustand );
    }
    catch ( Exception e )
    {
      System.out.println( "Fehler bei DCFdav.unsubscribeReceiveDavZustand() " + e.getMessage() );
      e.printStackTrace();
      return;
    }

  }

  /**
   * Lese Werte des Aspekts rechner.dfcStatus.zustand Hilfsfunktion zu update()
   */
  private void myupdate( ResultData[] resultData )
  {
    DataAspZustand dataAspZustand = new DataAspZustand();

    for (int i = 0; i < resultData.length; i++)
    {
      ResultData data = resultData[i];

      // ---------------------------------------------------------------------------------
      // Auswerten der Attributgruppe atg.dcfStatus
      // ---------------------------------------------------------------------------------
      if ( data.getDataDescription().getAttributeGroup().getPid().equals( "atg.dcfStatus" )
          && data.hasData() )
      {
        dataAspZustand.aktuellerZeitserver = data.getData().getTextValue( "AktuellerZeitServer" )
            .getValueText();

        int arrLength = data.getData().getArray( "VorhandeneZeitServer" ).getLength();
        dataAspZustand.vorhandeneZeitserver = new String[arrLength];
        for (int j = 0; j < arrLength; j++)
        {
          dataAspZustand.vorhandeneZeitserver[j] = data.getData().getArray( "VorhandeneZeitServer" )
              .getItem( j ).getTextValue( "VorhandenerZeitServer" ).getText();
        }
        dataAspZustand.letzteKorrekturZeit = data.getData().getTextValue( "LetzteZeitKorrektur" )
            .getText();
        dataAspZustand.aus( "Automatisch Empfangen" );
        m_gelesenerDataAspZustand = dataAspZustand;
        m_neuerZustand = true;
      } // end if
      // ---------------------------------------------------------------------------------
    } // end for
  } // end myupdate

  /**
   * Verbindung zum Sender, Empfaenger und Datenverteiler trennen
   */
  public void disconnect()
  {
    if ( m_isSubscribedReceiverDavZustand )
    {
      unsubscribeReceiveDavZustand();
    }

    if ( m_isSubscribedSendDavZustand )
    {
      unsubscribeSendDavZustand();
    }
    m_davConnection.disconnect( false, "" );
    return;
  }

  /**
   * Testroutine fuer das lokale Modul. Wird fuer verschiedene Tests im Laufe des Entwicklungs- und Wartungsprozesses verwendet
   *
   * @param args
   *          Testargumente
   */
  public static void main( String[] args )
  {
    DCFdav dcfDav = new DCFdav( args );
    dcfDav.subscribeSendDavZustand();
    dcfDav.subscribeSendDavZustand();

    return;
  }

  /**
   * Liefere pid des aktuellen Rechners (typ.rechner)
   *
   * @return rechnerPid des aktuellen Rechners, null wenn nicht gefunden
   */
  // -----------------------------------------------------------------------
  public String leseLokaleRechnerPid(  )
  {
    String rechnerPid = "";
    String tcpip_lokal = "";
    String rechner_lokal = "";
    try
    {
      InetAddress thisInetAddress = InetAddress.getLocalHost();
      rechner_lokal = thisInetAddress.getHostName();
      tcpip_lokal = thisInetAddress.getHostAddress();
    }
    catch ( Exception e )
    {
      String errMess = "InetAddress.getLocalHost().getHostName() Fehler";
      errMess += "\n" + e.getMessage();
      _debug.error( errMess );
      e.printStackTrace();
    }

    if ( m_davConnection == null )
    {
      String errMess = "keine Verbindung zum DAV" ;
      _debug.error( errMess );
      return (null);
    }

    DataModel dataModel = m_davConnection.getDataModel();

    SystemObjectType typeSysObj = null;
    typeSysObj = dataModel.getType( "typ.rechner" );
    if ( typeSysObj == null )
    {
      String errMess = "typ.rechner unbekannt" ;
      _debug.error( errMess );
      return null;
    }

    if ( typeSysObj.isConfigurating() )
      typeSysObj = (ConfigurationObjectType) typeSysObj;
    else
      typeSysObj = (DynamicObjectType) typeSysObj;

    // Elemente dieses Systemobjekts einlesen
    List<SystemObject> typobjekte = typeSysObj.getElements();

    Iterator<SystemObject> iterator_Typen = typobjekte.iterator();

    while ( iterator_Typen.hasNext() )
    {
      SystemObject sysObj = (SystemObject) iterator_Typen.next();
      if ( sysObj != null )
      {
        Data data = sysObj.getConfigurationData( dataModel
            .getAttributeGroup( "atg.rechnerInformation" ) );

        if ( data == null )
        {
          String errMess = "Für Rechner <"
              + sysObj.getName()
              + "> ist Attributgruppe <atg.rechnerInformation> nicht definiert";
          _debug.error( errMess );    
        }
        else
        {
          String tcpip_dav = data.getItem( "TCPIP" ).valueToString();
          String rechner_dav = data.getItem( "Name" ).valueToString();
          if ( (tcpip_lokal.equalsIgnoreCase(tcpip_dav)) 
              || (rechner_lokal.equalsIgnoreCase(rechner_dav))
          )
          {
            rechnerPid = sysObj.getPid();
            break;
          }
        } // date == null
      } // sysObj != null
    } // while
    
    if (rechnerPid=="")
    {
      String errMess = "";
      errMess += "lokaler Rechner "+ rechner_lokal
              + "(" + tcpip_lokal + ") nicht im DaV konfiguriert.";
      _debug.error(errMess);
    }

    return (rechnerPid);
  }
}
