/*
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 * 
 * Contact Information:
 * Dambach-Werke GmbH
 * Elektronische Leitsysteme
 * Fritz-Minhardt-Str. 1
 * 76456 Kuppenheim
 * Phone: +49-7222-402-0
 * Fax: +49-7222-402-200
 * mailto: info@els.dambach.de
 */

package de.bsvrz.sys.dcf77.zeitverw;

/**
 * Interface zum Testen der Zeitverwaltung, wird vom Tester verwendet.
 * Ueber dieses Interface liest ein eingebunder NTP Dienst das zuletzt
 * vom Zeitverwaltungs SenderThread in den DAV geschriebene Datum.
 *
 * @author ChriestenJ
 */

public interface IdcfTestReader
{

  /**
   * Testroutine: Liefert den zuletzt ueber den DAV empfangenen Rechner.dcfStatus.Zustand zurueck.
   * Falls seit dem letzten Aufruf kein Datum empfangen wurde, gibt die Routine null zurück.
   * Diese Routine wird eingesetzt, um die Versendung des SenderThreads zu testen.
   * @return gelesener Datensatz
   */
  public abstract DataAspZustand getNeuestenAspZustand();

  /**
   * Initialisiert einen Reader. Nach der Instanziierung des Konsumenten
   * ist der Reader automatisch geöffnet.
   */
  public abstract void openDCFtestReader();

  /**
   * Schliesst einen nicht mehr benötigten TestReader.
   */
  public abstract void closeDCFtestReader();
}
