/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.srp6.cli;

import com.nimbusds.srp6.BigIntegerUtils;
import com.nimbusds.srp6.SRP6CryptoParams;
import com.nimbusds.srp6.SRP6Exception;
import com.nimbusds.srp6.SRP6ServerSession;
import com.nimbusds.srp6.cli.SRP6Tool;
import java.io.IOException;
import java.math.BigInteger;

public class SRP6Server
extends SRP6Tool {
    @Override
    public void run() throws IOException {
        BigInteger M2;
        System.out.println("*** Nimbus SRP-6a server ***");
        System.out.println();
        System.out.println("Initialize server session");
        SRP6CryptoParams config = this.getConfig("\t");
        SRP6ServerSession server = new SRP6ServerSession(config);
        System.out.println("Server session step 1");
        System.out.print("\tEnter user identity 'I': ");
        String I = this.readInput();
        System.out.print("\tEnter password salt 's' (hex): ");
        BigInteger s = this.readBigInteger();
        System.out.print("\tEnter password verifier 'v' (hex): ");
        BigInteger v = this.readBigInteger();
        BigInteger B = server.step1(I, s, v);
        System.out.println();
        System.out.println("\tComputed public server value 'B' (hex): " + BigIntegerUtils.toHex(B));
        System.out.println();
        System.out.println("Server session step 2");
        System.out.print("\tEnter client public value 'A' (hex): ");
        BigInteger A = this.readBigInteger();
        System.out.print("\tEnter client evidence message 'M1' (hex): ");
        BigInteger M1 = this.readBigInteger();
        try {
            M2 = server.step2(A, M1);
        }
        catch (SRP6Exception e) {
            System.out.println(e.getMessage());
            return;
        }
        System.out.println();
        System.out.println("\tComputed server evidence message 'M2 (hex): " + BigIntegerUtils.toHex(M2));
        System.out.println();
        System.out.println("Mutual authentication successfully completed");
    }

    public static void main(String[] args) throws Exception {
        SRP6Server server = new SRP6Server();
        server.run();
    }
}

