/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.GanzZahl;
import de.bsvrz.sys.funclib.bitctrl.dua.MesswertMarkierung;

public abstract class AbstraktMesswert
extends MesswertMarkierung
implements Comparable<AbstraktMesswert> {
    private final String attName;
    private double wertSkaliert = -4.0;
    private long wertUnskaliert = -4L;
    private GanzZahl guete = GanzZahl.getGueteIndex();
    private int verfahren;

    protected AbstraktMesswert(String attName, Data datum) {
        if (attName == null) {
            throw new NullPointerException("Der Attributname ist <<null>>");
        }
        if (datum == null) {
            throw new NullPointerException("Das Datum ist <<null>>");
        }
        this.attName = attName;
        if (!this.isSkaliert()) {
            this.wertUnskaliert = datum.getItem(attName).getUnscaledValue("Wert").longValue();
        }
        this.setNichtErfasst(datum.getItem(attName).getItem("Status").getItem("Erfassung").getUnscaledValue("NichtErfasst").intValue() == 1);
        this.setFormalMax(datum.getItem(attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMax").intValue() == 1);
        this.setFormalMin(datum.getItem(attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMin").intValue() == 1);
        this.setLogischMax(datum.getItem(attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").intValue() == 1);
        this.setLogischMin(datum.getItem(attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMinLogisch").intValue() == 1);
        this.setImplausibel(datum.getItem(attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").intValue() == 1);
        this.setInterpoliert(datum.getItem(attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Interpoliert").intValue() == 1);
        this.guete.setWert(datum.getItem(attName).getItem("G\u00fcte").getUnscaledValue("Index").longValue());
        this.verfahren = datum.getItem(attName).getItem("G\u00fcte").getUnscaledValue("Verfahren").intValue();
    }

    protected AbstraktMesswert(String attName) {
        this.attName = attName;
    }

    public abstract boolean isSkaliert();

    public final GanzZahl getGueteIndex() {
        return this.guete;
    }

    public final void setGueteIndex(GanzZahl guete1) {
        this.guete = guete1;
    }

    public final int getVerfahren() {
        return this.verfahren;
    }

    public final void setVerfahren(int verfahren) {
        this.verfahren = verfahren;
    }

    public final void setWertSkaliert(double wert) {
        this.wertSkaliert = wert;
    }

    public final double getWertSkaliert() {
        return this.wertSkaliert;
    }

    public final void setWertUnskaliert(long wert) {
        this.wertUnskaliert = wert;
    }

    public final long getWertUnskaliert() {
        return this.wertUnskaliert;
    }

    public final boolean isFehlerhaftBzwImplausibel() {
        return this.wertUnskaliert == -2L || this.wertUnskaliert == -3L || this.isImplausibel();
    }

    @Override
    public int compareTo(AbstraktMesswert that) {
        return this.isSkaliert() ? Double.compare(this.getWertSkaliert(), that.getWertSkaliert()) : Long.compare(this.getWertUnskaliert(), that.getWertUnskaliert());
    }

    public final void kopiereInhaltNach(Data datum) {
        if (this.isSkaliert()) {
            datum.getItem(this.attName).getScaledValue("Wert").set(this.wertSkaliert);
        } else if (DUAUtensilien.isWertInWerteBereich(datum.getItem(this.attName).getItem("Wert"), this.wertUnskaliert)) {
            datum.getItem(this.attName).getUnscaledValue("Wert").set(this.wertUnskaliert);
        } else {
            datum.getItem(this.attName).getUnscaledValue("Wert").set(-3);
        }
        datum.getItem(this.attName).getItem("Status").getItem("Erfassung").getUnscaledValue("NichtErfasst").set(this.isNichtErfasst() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMax").set(this.isFormalMax() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMin").set(this.isFormalMin() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").set(this.isLogischMax() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMinLogisch").set(this.isLogischMin() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").set(this.isImplausibel() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Interpoliert").set(this.isInterpoliert() ? 1 : 0);
        datum.getItem(this.attName).getItem("G\u00fcte").getUnscaledValue("Index").set(this.guete.getWert());
        datum.getItem(this.attName).getItem("G\u00fcte").getUnscaledValue("Verfahren").set(this.verfahren);
    }

    public final void kopiereInhaltNachModifiziereIndex(Data datum) {
        if (this.isSkaliert()) {
            datum.getItem(this.attName).getScaledValue("Wert").set(this.wertSkaliert);
        } else if (DUAUtensilien.isWertInWerteBereich(datum.getItem(this.attName).getItem("Wert"), this.wertUnskaliert)) {
            datum.getItem(this.attName).getUnscaledValue("Wert").set(this.wertUnskaliert);
        } else {
            datum.getItem(this.attName).getUnscaledValue("Wert").set(-3);
        }
        datum.getItem(this.attName).getItem("Status").getItem("Erfassung").getUnscaledValue("NichtErfasst").set(this.isNichtErfasst() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMax").set(this.isFormalMax() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlFormal").getUnscaledValue("WertMin").set(this.isFormalMin() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMaxLogisch").set(this.isLogischMax() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("PlLogisch").getUnscaledValue("WertMinLogisch").set(this.isLogischMin() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Implausibel").set(this.isImplausibel() ? 1 : 0);
        datum.getItem(this.attName).getItem("Status").getItem("MessWertErsetzung").getUnscaledValue("Interpoliert").set(this.isInterpoliert() ? 1 : 0);
        if (datum.getItem(this.attName).getUnscaledValue("Wert").longValue() < 0L) {
            datum.getItem(this.attName).getItem("G\u00fcte").getUnscaledValue("Index").set(0);
        } else {
            datum.getItem(this.attName).getItem("G\u00fcte").getUnscaledValue("Index").set(this.guete.getWert());
        }
        datum.getItem(this.attName).getItem("G\u00fcte").getUnscaledValue("Verfahren").set(this.verfahren);
    }

    public boolean equals(Object obj) {
        boolean gleich = false;
        if (obj instanceof AbstraktMesswert) {
            AbstraktMesswert that = (AbstraktMesswert)obj;
            gleich = super.equals(obj) && this.getWertUnskaliert() == that.getWertUnskaliert() && this.guete.equals(that.guete);
        }
        return gleich;
    }

    @Override
    public String toString() {
        return (this.isSkaliert() ? this.getWertSkaliert() : (double)this.getWertUnskaliert()) + " " + super.toString() + " " + this.guete.getSkaliertenWert() + " (" + this.verfahren + ")";
    }

    public final String getName() {
        return this.attName;
    }
}

