/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.AttributeType;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.IntegerAttributeType;
import de.bsvrz.dav.daf.main.config.IntegerValueRange;
import de.bsvrz.dav.daf.main.config.IntegerValueState;
import de.bsvrz.dav.daf.main.config.ObjectTimeSpecification;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.dav.daf.main.impl.config.DafConfigurationAuthority;
import de.bsvrz.dav.daf.main.impl.config.DafConfigurationObject;
import de.bsvrz.dav.daf.main.impl.config.DafDynamicObject;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.debug.Debug;
import de.bsvrz.sys.funclib.operatingMessage.MessageCauser;
import de.bsvrz.sys.funclib.operatingMessage.MessageGrade;
import de.bsvrz.sys.funclib.operatingMessage.MessageSender;
import de.bsvrz.sys.funclib.operatingMessage.MessageState;
import de.bsvrz.sys.funclib.operatingMessage.MessageType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;

public final class DUAUtensilien {
    private static final Debug LOGGER = Debug.getLogger();
    private static ClientSenderInterface parameterSender;
    private static final String NATUERLICHE_ZAHL = "\\d+";

    private DUAUtensilien() {
    }

    public static String ersetzeLetztesElemInAttPfad(String attPfad, String ersetzung) {
        Object ergebnis = null;
        if (attPfad != null && attPfad.length() > 0 && ersetzung != null && ersetzung.length() > 0) {
            int letzterPunkt = attPfad.lastIndexOf(".");
            ergebnis = letzterPunkt != -1 ? attPfad.substring(0, letzterPunkt + 1) + ersetzung : ersetzung;
        }
        return ergebnis;
    }

    public static Collection<DAVObjektAnmeldung> getAlleObjektAnmeldungen(SystemObject obj, DataDescription datenBeschreibung, ClientDavInterface dav) {
        TreeSet<DAVObjektAnmeldung> anmeldungen = new TreeSet<DAVObjektAnmeldung>();
        Collection<SystemObject> finObjekte = DUAUtensilien.getBasisInstanzen(obj, dav);
        for (SystemObject finObj : finObjekte) {
            if (datenBeschreibung == null || datenBeschreibung.getAttributeGroup() == null && datenBeschreibung.getAspect() == null) {
                for (AttributeGroup atg : finObj.getType().getAttributeGroups()) {
                    for (Aspect asp : atg.getAspects()) {
                        anmeldungen.add(new DAVObjektAnmeldung(finObj, new DataDescription(atg, asp)));
                    }
                }
                continue;
            }
            if (datenBeschreibung.getAttributeGroup() == null) {
                for (AttributeGroup atg : finObj.getType().getAttributeGroups()) {
                    try {
                        anmeldungen.add(new DAVObjektAnmeldung(finObj, new DataDescription(atg, datenBeschreibung.getAspect())));
                    }
                    catch (IllegalArgumentException ex) {
                        LOGGER.fine("", (Throwable)ex);
                    }
                }
                continue;
            }
            if (datenBeschreibung.getAspect() == null) {
                for (Aspect asp : datenBeschreibung.getAttributeGroup().getAspects()) {
                    anmeldungen.add(new DAVObjektAnmeldung(finObj, new DataDescription(datenBeschreibung.getAttributeGroup(), asp)));
                }
                continue;
            }
            anmeldungen.add(new DAVObjektAnmeldung(finObj, datenBeschreibung));
        }
        return anmeldungen;
    }

    public static String getArgument(String schluessel, List<String> argumentListe) {
        String ergebnis = null;
        if (schluessel != null && argumentListe != null) {
            for (String argument : argumentListe) {
                String[] teile = argument.split("=");
                if (teile == null || teile.length <= 1 || !teile[0].equals("-" + schluessel)) continue;
                ergebnis = teile[1];
                break;
            }
        }
        return ergebnis;
    }

    public static Data getAttributDatum(String attributPfad, Data datum) {
        Data ergebnis = null;
        if (datum != null) {
            if (attributPfad != null) {
                String[] elemente = attributPfad.split("[.]");
                ergebnis = datum;
                for (String element : elemente) {
                    if (ergebnis != null) {
                        if (element.length() == 0) {
                            LOGGER.warning("Syntaxfehler in Attributpfad: \"" + attributPfad + "\"");
                            return null;
                        }
                        if (element.matches(NATUERLICHE_ZAHL)) {
                            ergebnis = ergebnis.asArray().getItem(Integer.parseInt(element));
                            continue;
                        }
                        ergebnis = ergebnis.getItem(element);
                        continue;
                    }
                    LOGGER.warning("Datensatz " + datum + " kann nicht bis \"" + attributPfad + "\" exploriert werden.");
                }
            } else {
                LOGGER.warning("\u00dcbergebener Attributpfad ist <<null>>");
            }
        } else {
            LOGGER.warning("\u00dcbergebenes Datum ist <<null>>");
        }
        return ergebnis;
    }

    public static Collection<SystemObject> getBasisInstanzen(SystemObject obj, ClientDavInterface dav) {
        HashSet<SystemObject> finaleObjekte = new HashSet<SystemObject>();
        if (obj == null || obj.getPid().equals("typ.typ")) {
            SystemObjectType typTyp = dav.getDataModel().getType("typ.typ");
            for (SystemObject typ : typTyp.getElements()) {
                if (!typ.isValid() || !(typ instanceof SystemObjectType)) continue;
                for (SystemObject elem : ((SystemObjectType)typ).getElements()) {
                    if (!elem.isValid() || !elem.getClass().equals(DafConfigurationObject.class) && !elem.getClass().equals(DafDynamicObject.class) && !elem.getClass().equals(DafConfigurationAuthority.class)) continue;
                    finaleObjekte.add(elem);
                }
            }
        } else if (obj instanceof SystemObjectType) {
            SystemObjectType typ = (SystemObjectType)obj;
            for (SystemObject elem : typ.getElements()) {
                if (!elem.isValid()) continue;
                finaleObjekte.addAll(DUAUtensilien.getBasisInstanzen(elem, dav));
            }
        } else if (obj.getClass().equals(DafConfigurationObject.class) || obj.getClass().equals(DafDynamicObject.class) || obj.getClass().equals(DafConfigurationAuthority.class)) {
            finaleObjekte.add(obj);
        } else {
            LOGGER.fine("Das \u00fcbergebene Objekt ist weder ein Typ, ein Konfigurationsobjekt, ein dynamisches Objekt noch eine Konfigurationsautorit\u00e4t: " + obj);
        }
        return finaleObjekte;
    }

    public static Collection<SystemObject> getBasisInstanzen(SystemObject obj, ClientDavInterface dav, Collection<ConfigurationArea> kBereichsFilter) {
        HashSet<SystemObject> finaleObjekte = new HashSet<SystemObject>();
        Collection<Object> benutzteBereiche = new HashSet<ConfigurationArea>();
        if (kBereichsFilter != null && kBereichsFilter.size() > 0) {
            benutzteBereiche = kBereichsFilter;
        } else {
            benutzteBereiche.add(dav.getDataModel().getConfigurationAuthority().getConfigurationArea());
        }
        if (obj == null || obj.getPid().equals("typ.typ")) {
            TreeSet<SystemObjectType> typColl = new TreeSet<SystemObjectType>();
            for (SystemObject systemObject : dav.getDataModel().getType("typ.typ").getElements()) {
                if (!systemObject.isValid() || !(systemObject instanceof SystemObjectType)) continue;
                typColl.add((SystemObjectType)systemObject);
            }
            for (ConfigurationArea configurationArea : benutzteBereiche) {
                for (SystemObject elem : configurationArea.getObjects(typColl, ObjectTimeSpecification.valid())) {
                    if (!elem.getClass().equals(DafConfigurationObject.class) && !elem.getClass().equals(DafDynamicObject.class) && !elem.getClass().equals(DafConfigurationAuthority.class)) continue;
                    finaleObjekte.add(elem);
                }
            }
        } else if (obj instanceof SystemObjectType) {
            ArrayList<SystemObjectType> typColl = new ArrayList<SystemObjectType>();
            typColl.add((SystemObjectType)obj);
            for (ConfigurationArea configurationArea : benutzteBereiche) {
                for (SystemObject elem : configurationArea.getObjects(typColl, ObjectTimeSpecification.valid())) {
                    if (!elem.getClass().equals(DafConfigurationObject.class) && !elem.getClass().equals(DafDynamicObject.class) && !elem.getClass().equals(DafConfigurationAuthority.class)) continue;
                    finaleObjekte.add(elem);
                }
            }
        } else if (obj.getClass().equals(DafConfigurationObject.class) || obj.getClass().equals(DafDynamicObject.class) || obj.getClass().equals(DafConfigurationAuthority.class)) {
            if (benutzteBereiche.contains(obj.getConfigurationArea())) {
                finaleObjekte.add(obj);
            }
        } else {
            LOGGER.fine("Das \u00fcbergebene Objekt ist weder ein Typ, ein Konfigurationsobjekt, ein dynamisches Objekt noch eine Konfigurationsautorit\u00e4t: " + obj);
        }
        return finaleObjekte;
    }

    public static int getStundenVonTag(long zeitStempel) {
        int stundenDesTages = 24;
        GregorianCalendar cal1 = new GregorianCalendar();
        GregorianCalendar cal2 = new GregorianCalendar();
        cal1.setTimeInMillis(zeitStempel);
        cal2.setTimeInMillis(zeitStempel);
        cal1.set(11, 0);
        cal2.set(11, 10);
        if ((long)cal1.get(16) / 60L / 60L / 1000L == 0L && (long)cal2.get(16) / 60L / 60L / 1000L == 1L) {
            stundenDesTages = 23;
        }
        if ((long)cal1.get(16) / 60L / 60L / 1000L == 1L && (long)cal2.get(16) / 60L / 60L / 1000L == 0L) {
            stundenDesTages = 25;
        }
        return stundenDesTages;
    }

    public static String getTextZuMesswert(long messwert) {
        Object s = "undefiniert (" + messwert + ")";
        if (messwert >= 0L) {
            s = new Long(messwert).toString();
        } else if (messwert == -1L) {
            s = "nicht ermittelbar";
        } else if (messwert == -2L) {
            s = "fehlerhaft";
        } else if (messwert == -3L) {
            s = "nicht ermittelbar/fehlerhaft";
        }
        return s;
    }

    public static String isKombinationOk(SystemObject obj, DataDescription datenBeschreibung) {
        Object result = null;
        if (obj == null) {
            result = "Objekt ist <<null>>";
        } else if (datenBeschreibung == null) {
            result = "Datenbeschreibung ist <<null>>";
        } else if (datenBeschreibung.getAttributeGroup() == null) {
            result = "Attributgruppe ist <<null>>";
        } else if (datenBeschreibung.getAspect() == null) {
            result = "Aspekt ist <<null>>";
        } else if (!obj.getType().getAttributeGroups().contains(datenBeschreibung.getAttributeGroup())) {
            result = "Attributgruppe " + datenBeschreibung.getAttributeGroup() + " ist f\u00fcr Objekt " + obj + " nicht definiert";
        } else if (!datenBeschreibung.getAttributeGroup().getAspects().contains(datenBeschreibung.getAspect())) {
            result = "Aspekt " + datenBeschreibung.getAspect() + " ist f\u00fcr Attributgruppe " + datenBeschreibung.getAttributeGroup() + " nicht definiert";
        } else if (!(obj.getClass().equals(DafConfigurationObject.class) || obj.getClass().equals(DafDynamicObject.class) || obj.getClass().equals(DafConfigurationAuthority.class))) {
            result = "Es handelt sich weder um ein Konfigurationsobjekt, ein dynamisches Objekt noch eine Konfigurationsautorit\u00e4t: " + obj;
        }
        return result;
    }

    public static boolean isWertInWerteBereich(Data attribut, double wertSkaliert) {
        boolean ergebnis = true;
        if (attribut != null) {
            long wertUnskaliert;
            IntegerValueRange wertebereich;
            AttributeType typ = attribut.getAttributeType();
            if (typ instanceof IntegerAttributeType && (wertebereich = ((IntegerAttributeType)typ).getRange()) != null && ((wertUnskaliert = Math.round(wertSkaliert / wertebereich.getConversionFactor())) < wertebereich.getMinimum() || wertUnskaliert > wertebereich.getMaximum())) {
                ergebnis = false;
            }
        } else {
            throw new NullPointerException("\u00dcbergebenes Attribut ist <<null>>");
        }
        return ergebnis;
    }

    public static boolean isWertInWerteBereich(Data attribut, long wert) {
        boolean ergebnis = true;
        if (attribut != null) {
            AttributeType typ = attribut.getAttributeType();
            if (typ instanceof IntegerAttributeType) {
                IntegerValueRange wertebereich;
                List statuss = ((IntegerAttributeType)typ).getStates();
                if (!statuss.isEmpty()) {
                    for (IntegerValueState status : ((IntegerAttributeType)typ).getStates()) {
                        if (wert != status.getValue()) continue;
                        return true;
                    }
                }
                if ((wertebereich = ((IntegerAttributeType)typ).getRange()) != null && (wert < wertebereich.getMinimum() || wert > wertebereich.getMaximum())) {
                    ergebnis = false;
                }
            }
        } else {
            throw new NullPointerException("\u00dcbergebenes Attribut ist <<null>>");
        }
        return ergebnis;
    }

    public static String runde(double wert, int nachkommastellen) {
        double nachkommaDouble = Math.pow(10.0, nachkommastellen);
        return new Double((double)Math.round(wert * nachkommaDouble) / nachkommaDouble).toString();
    }

    public static String getVergleichsIntervallInText(long vergleichsIntervallInMs) {
        StringBuilder text = new StringBuilder();
        try {
            long val = vergleichsIntervallInMs;
            int millis = (int)(val % 1000L);
            int seconds = (int)((val /= 1000L) % 60L);
            int minutes = (int)((val /= 60L) % 60L);
            int hours = (int)((val /= 60L) % 24L);
            long days = val /= 24L;
            if (days != 0L) {
                if (days == 1L) {
                    text.append("1 Tag ");
                } else if (days == -1L) {
                    text.append("-1 Tag ");
                } else {
                    text.append(days).append(" Tage ");
                }
            }
            if (hours != 0) {
                if (hours == 1) {
                    text.append("1 Stunde ");
                } else if (hours == -1) {
                    text.append("-1 Stunde ");
                } else {
                    text.append(hours).append(" Stunden ");
                }
            }
            if (minutes != 0) {
                if (minutes == 1) {
                    text.append("1 Minute ");
                } else if (minutes == -1) {
                    text.append("-1 Minute ");
                } else {
                    text.append(minutes).append(" Minuten ");
                }
            }
            if (seconds != 0 || days == 0L && hours == 0 && minutes == 0 && millis == 0) {
                if (seconds == 1) {
                    text.append("1 Sekunde ");
                } else if (seconds == -1) {
                    text.append("-1 Sekunde ");
                } else {
                    text.append(seconds).append(" Sekunden ");
                }
            }
            if (millis != 0) {
                if (millis == 1) {
                    text.append("1 Millisekunde ");
                } else if (millis == -1) {
                    text.append("-1 Millisekunde ");
                } else {
                    text.append(millis).append(" Millisekunden ");
                }
            }
            text.setLength(text.length() - 1);
        }
        catch (Exception e) {
            LOGGER.finest(e.getLocalizedMessage(), (Throwable)e);
            return "[" + vergleichsIntervallInMs + "ms]";
        }
        return text.toString();
    }

    public static String getArrayKurzInfo(Object[] objekte) {
        Object kurzInfo = "";
        if (objekte != null) {
            kurzInfo = new Integer(objekte.length).toString();
            if (objekte.length > 0) {
                kurzInfo = (String)kurzInfo + " [";
                for (Object obj : objekte) {
                    String dummy = null;
                    if (obj == null) {
                        dummy = "<<null>>";
                    } else {
                        dummy = obj.toString();
                        if (dummy == null) {
                            dummy = "$<<null>>";
                        }
                    }
                    kurzInfo = (String)kurzInfo + dummy + ", ";
                    if (((String)kurzInfo).length() <= 70) continue;
                    kurzInfo = ((String)kurzInfo).substring(0, 70) + "..., ";
                    break;
                }
                kurzInfo = ((String)kurzInfo).substring(0, ((String)kurzInfo).length() - 2);
                kurzInfo = (String)kurzInfo + "]";
            }
        } else {
            kurzInfo = "<<null>>";
        }
        return kurzInfo;
    }

    public static boolean isObjektInKBsEnthalten(SystemObject obj, ConfigurationArea[] kbs) {
        boolean enthalten = true;
        if (kbs != null && kbs.length > 0) {
            enthalten = false;
            for (ConfigurationArea kb : kbs) {
                if (!obj.getConfigurationArea().equals(kb)) continue;
                enthalten = true;
                break;
            }
        }
        return enthalten;
    }

    public static void setAlleParameter(ClientDavInterface dav) {
        DataDescription datenBeschreibung = new DataDescription(dav.getDataModel().getAttributeGroup("atg.parametrierung"), dav.getDataModel().getAspect("asp.parameterVorgabe"));
        if (parameterSender == null) {
            parameterSender = new ClientSenderInterface(){

                public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
                }

                public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
                    return false;
                }
            };
            try {
                dav.subscribeSender(parameterSender, (SystemObject)dav.getDataModel().getConfigurationAuthority(), datenBeschreibung, SenderRole.sender());
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException ex) {
                    LOGGER.finest(ex.getLocalizedMessage(), (Throwable)ex);
                }
            }
            catch (OneSubscriptionPerSendData e) {
                throw new RuntimeException(e);
            }
        }
        Data atgData = dav.createData(datenBeschreibung.getAttributeGroup());
        atgData.getItem("Urlasser").getReferenceValue("BenutzerReferenz").setSystemObject(null);
        atgData.getItem("Urlasser").getTextValue("Ursache").setText("");
        atgData.getItem("Urlasser").getTextValue("Veranlasser").setText("");
        atgData.getArray("ParameterSatz").setLength(1);
        atgData.getArray("ParameterSatz").getItem(0).getReferenceArray("Bereich").setLength(0);
        atgData.getArray("ParameterSatz").getItem(0).getArray("DatenSpezifikation").setLength(1);
        atgData.getArray("ParameterSatz").getItem(0).getArray("DatenSpezifikation").getItem(0).getReferenceArray("Objekt").setLength(0);
        atgData.getArray("ParameterSatz").getItem(0).getArray("DatenSpezifikation").getItem(0).getReferenceArray("AttributGruppe").setLength(0);
        atgData.getArray("ParameterSatz").getItem(0).getArray("DatenSpezifikation").getItem(0).getUnscaledValue("SimulationsVariante").set(0);
        atgData.getArray("ParameterSatz").getItem(0).getItem("Einstellungen").getUnscaledValue("Parametrieren").set(1);
        ResultData resultat = new ResultData((SystemObject)dav.getDataModel().getConfigurationAuthority(), datenBeschreibung, System.currentTimeMillis(), atgData);
        try {
            dav.sendData(resultat);
        }
        catch (DataNotSubscribedException | SendSubscriptionNotConfirmed e) {
            throw new RuntimeException(e);
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException ex) {
            LOGGER.finest(ex.getLocalizedMessage(), (Throwable)ex);
        }
    }

    public static void sendeBetriebsmeldung(ClientDavInterface dav, MessageGrade grade, SystemObject objekt, String nachricht) {
        MessageSender.getInstance().sendMessage(MessageType.APPLICATION_DOMAIN, null, grade, objekt, new MessageCauser((SystemObject)dav.getLocalUser(), "", ""), nachricht);
    }

    public static void sendeBetriebsmeldung(ClientDavInterface dav, String id, MessageGrade grade, SystemObject objekt, String nachricht) {
        if (id == null) {
            DUAUtensilien.sendeBetriebsmeldung(dav, grade, objekt, nachricht);
            return;
        }
        String msgId = objekt.getNameOrPidOrId();
        MessageSender.getInstance().sendMessage(msgId, MessageType.APPLICATION_DOMAIN, null, grade, objekt, MessageState.MESSAGE, new MessageCauser((SystemObject)dav.getLocalUser(), "", ""), nachricht);
    }

    public static Collection<ConfigurationArea> getKonfigurationsBereicheAlsObjekte(ClientDavInterface dav, String kbString) {
        ArrayList<Object> resultListe = new ArrayList<Object>();
        if (kbString != null) {
            String[] s = kbString.split(",");
            for (String dummy : s) {
                if (dummy == null || dummy.length() <= 0) continue;
                resultListe.add(dummy);
            }
        }
        HashSet<ConfigurationArea> kbListe = new HashSet<ConfigurationArea>();
        for (String string : resultListe) {
            ConfigurationArea area = dav.getDataModel().getConfigurationArea(string);
            if (area == null) continue;
            kbListe.add(area);
        }
        return kbListe;
    }
}

