/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.sys.funclib.bitctrl.daf.AbstractDavZustand;
import de.bsvrz.sys.funclib.bitctrl.dua.MesswertZustand;

public class GanzZahl
implements Comparable<GanzZahl> {
    private long wert;
    private double skalierungsFaktor = 1.0;
    private AbstractDavZustand[] zustaende;
    private AbstractDavZustand aktuellerZustand;

    public static final GanzZahl getMWZahl() {
        return new GanzZahl(new AbstractDavZustand[]{MesswertZustand.FEHLERHAFT, MesswertZustand.NICHT_ERMITTELBAR, MesswertZustand.FEHLERHAFT_BZW_NICHT_ERMITTELBAR});
    }

    public static final GanzZahl getGueteIndex() {
        GanzZahl gueteIndex = new GanzZahl(1.0E-4, new AbstractDavZustand[]{MesswertZustand.FEHLERHAFT, MesswertZustand.NICHT_ERMITTELBAR, MesswertZustand.FEHLERHAFT_BZW_NICHT_ERMITTELBAR});
        gueteIndex.setWert(10000L);
        return gueteIndex;
    }

    public GanzZahl() {
    }

    public GanzZahl(double skalierungsFaktor) {
        this.skalierungsFaktor = skalierungsFaktor;
    }

    public GanzZahl(AbstractDavZustand[] zustaende) {
        this.zustaende = zustaende;
        this.setWert(0L);
    }

    public GanzZahl(double skalierungsFaktor, AbstractDavZustand[] zustaende) {
        this.skalierungsFaktor = skalierungsFaktor;
        this.zustaende = zustaende;
        this.setWert(0L);
    }

    public GanzZahl(GanzZahl vorlage) {
        this.wert = vorlage.wert;
        this.skalierungsFaktor = vorlage.skalierungsFaktor;
        this.zustaende = new AbstractDavZustand[vorlage.zustaende.length];
        for (int i = 0; i < vorlage.zustaende.length; ++i) {
            this.zustaende[i] = vorlage.zustaende[i];
        }
        this.aktuellerZustand = vorlage.aktuellerZustand;
    }

    public final long getWert() {
        return this.wert;
    }

    public void setWert(long wert) {
        this.wert = wert;
        if (this.zustaende != null) {
            this.aktuellerZustand = null;
            for (AbstractDavZustand zustand : this.zustaende) {
                if ((long)zustand.getCode() != this.wert) continue;
                this.aktuellerZustand = zustand;
                break;
            }
        }
    }

    public final void setSkaliertenWert(double wert1) {
        double skalierung = this.skalierungsFaktor;
        this.setWert(Math.round(wert1 / skalierung));
    }

    public final double getSkaliertenWert() {
        return (double)this.getWert() * this.skalierungsFaktor;
    }

    public final void setZustand(AbstractDavZustand zustand) {
        assert (zustand != null);
        this.wert = zustand.getCode();
        this.aktuellerZustand = zustand;
    }

    public final AbstractDavZustand getZustand() {
        return this.aktuellerZustand;
    }

    public final boolean isZustand() {
        return this.aktuellerZustand != null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("Wert (unskaliert): ").append(this.getWert());
        s.append("\nWert (skaliert): ").append(this.getSkaliertenWert()).append(", (F: ").append(this.skalierungsFaktor).append(")");
        s.append("\nZustaende: ");
        if (this.zustaende == null || this.zustaende.length == 0) {
            s.append("keine");
        } else {
            for (AbstractDavZustand zustand : this.zustaende) {
                s.append("\n").append(zustand.toString()).append(" (").append(zustand.getCode()).append(")");
            }
            s.append("\nAktueller Zustand: ");
            if (this.isZustand()) {
                s.append(this.getZustand().toString()).append(" (").append(this.getZustand().getCode()).append(")");
            } else {
                s.append("keiner");
            }
        }
        return s.toString();
    }

    @Override
    public int compareTo(GanzZahl that) {
        if (that == null) {
            throw new NullPointerException("Vergleichswert ist <<null>>");
        }
        return new Long(this.getWert()).compareTo(that.getWert());
    }
}

