/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IKontrollProzessListener;
import de.bsvrz.sys.funclib.debug.Debug;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Timer;
import java.util.TimerTask;

public class KontrollProzess<T> {
    private final Timer timer;
    private Prozess prozess;
    private long naechsterAufrufZeitpunkt = -1L;
    private T aktuelleInformation;
    private final Collection<IKontrollProzessListener<T>> listenerMenge = Collections.synchronizedSet(new HashSet());

    public KontrollProzess() {
        this.timer = new Timer();
        this.prozess = new Prozess();
    }

    public final synchronized void setNaechstenAufrufZeitpunkt(long zeitpunktInMillis) {
        if (this.naechsterAufrufZeitpunkt != zeitpunktInMillis) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS");
            Debug.getLogger().info("Der eingeplante Kontrollzeitpunkt wird ver\u00e4ndert\nAlt: " + dateFormat.format(new Date(this.naechsterAufrufZeitpunkt)) + "\nNeu: " + dateFormat.format(new Date(zeitpunktInMillis)));
            this.naechsterAufrufZeitpunkt = zeitpunktInMillis;
            this.prozess.cancel();
            this.timer.purge();
            this.prozess = new Prozess();
            this.timer.schedule((TimerTask)this.prozess, new Date(this.naechsterAufrufZeitpunkt));
        }
    }

    public final synchronized void setNaechstenAufrufZeitpunkt(long zeitpunktInMillis, T information) {
        this.aktuelleInformation = information;
        this.setNaechstenAufrufZeitpunkt(zeitpunktInMillis);
    }

    public final synchronized long getNaechstenAufrufZeitpunkt() {
        return this.naechsterAufrufZeitpunkt;
    }

    public final synchronized void setInformation(T information) {
        this.aktuelleInformation = information;
    }

    public final synchronized T getInformation() {
        return this.aktuelleInformation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IKontrollProzessListener<T> listener) {
        if (listener != null) {
            Collection<IKontrollProzessListener<T>> collection = this.listenerMenge;
            synchronized (collection) {
                this.listenerMenge.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(IKontrollProzessListener<T> listener) {
        if (listener != null) {
            Collection<IKontrollProzessListener<T>> collection = this.listenerMenge;
            synchronized (collection) {
                this.listenerMenge.remove(listener);
            }
        }
    }

    protected class Prozess
    extends TimerTask {
        protected Prozess() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Collection collection = KontrollProzess.this.listenerMenge;
            synchronized (collection) {
                for (IKontrollProzessListener listener : KontrollProzess.this.listenerMenge) {
                    listener.trigger(KontrollProzess.this.aktuelleInformation);
                }
            }
        }
    }
}

