/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.adapter.AbstraktBearbeitungsKnotenAdapter;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.DFSKonstanten;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerungFuerModul;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.ModulTyp;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IStandardAspekte;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class PublikationsModul
extends AbstraktBearbeitungsKnotenAdapter {
    private final ModulTyp modulTyp;
    private IDatenFlussSteuerungFuerModul iDfsMod = DFSKonstanten.STANDARD;
    private final Map<SystemObject, Boolean> keineDaten = new HashMap<SystemObject, Boolean>();

    public PublikationsModul(IStandardAspekte stdAspekte, ModulTyp modulTyp) {
        this.setStandardAspekte(stdAspekte);
        this.modulTyp = modulTyp;
    }

    @Override
    public void initialisiere(IVerwaltung dieVerwaltung) throws DUAInitialisierungsException {
        super.initialisiere(dieVerwaltung);
        this.getPublikationsAnmeldungen().modifiziereObjektAnmeldung(this.getStandardAspekte().getStandardAnmeldungen(this.getVerwaltung().getSystemObjekte()));
        for (SystemObject objekt : this.getVerwaltung().getSystemObjekte()) {
            this.keineDaten.put(objekt, true);
        }
    }

    @Override
    public void aktualisiereDaten(ResultData[] resultate) {
        if (resultate != null) {
            for (ResultData resultat : resultate) {
                if (resultat == null) continue;
                ResultData publikationsDatum = null;
                publikationsDatum = this.modulTyp != null ? this.iDfsMod.getPublikationsDatum(resultat, resultat.getData(), this.getStandardAspekte().getStandardAspekt(resultat)) : new ResultData(resultat.getObject(), new DataDescription(resultat.getDataDescription().getAttributeGroup(), this.getStandardAspekte().getStandardAspekt(resultat)), resultat.getDataTime(), resultat.getData());
                if (publikationsDatum == null) continue;
                if (publikationsDatum.getData() == null) {
                    Boolean objektStehtAktuellAufKeineDaten = this.keineDaten.get(publikationsDatum.getObject());
                    if (objektStehtAktuellAufKeineDaten != null && !objektStehtAktuellAufKeineDaten.booleanValue()) {
                        this.getPublikationsAnmeldungen().sende(publikationsDatum);
                    }
                } else {
                    this.getPublikationsAnmeldungen().sende(publikationsDatum);
                }
                this.keineDaten.put(publikationsDatum.getObject(), publikationsDatum.getData() == null);
            }
            if (this.getKnoten() != null) {
                this.getKnoten().aktualisiereDaten(resultate);
            }
        }
    }

    @Override
    public ModulTyp getModulTyp() {
        return this.modulTyp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aktualisierePublikation(IDatenFlussSteuerung iDfs) {
        if (this.modulTyp != null) {
            this.iDfsMod = iDfs.getDFSFuerModul(this.getVerwaltung().getSWETyp(), this.getModulTyp());
            Collection<DAVObjektAnmeldung> anmeldungenStd = new ArrayList<DAVObjektAnmeldung>();
            if (this.getStandardAspekte() != null) {
                anmeldungenStd = this.getStandardAspekte().getStandardAnmeldungen(this.getVerwaltung().getSystemObjekte());
            }
            Collection<DAVObjektAnmeldung> anmeldungen = this.iDfsMod.getDatenAnmeldungen(this.getVerwaltung().getSystemObjekte(), anmeldungenStd);
            PublikationsModul publikationsModul = this;
            synchronized (publikationsModul) {
                this.getPublikationsAnmeldungen().modifiziereObjektAnmeldung(anmeldungen);
            }
        }
    }
}

