/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua;

import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.DataModel;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.dav.daf.main.config.SystemObjectType;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IStandardAspekte;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public abstract class StandardAspekteVersorger {
    protected final IVerwaltung verwaltung;
    protected IStandardAspekte standardAspekte = new IStandardAspekte(){

        @Override
        public Collection<DAVObjektAnmeldung> getStandardAnmeldungen(SystemObject[] objektFilter) {
            return new ArrayList<DAVObjektAnmeldung>();
        }

        @Override
        public Aspect getStandardAspekt(ResultData originalDatum) {
            return null;
        }

        @Override
        public Collection<AttributeGroup> getAlleAttributGruppen() {
            return new ArrayList<AttributeGroup>();
        }
    };

    public StandardAspekteVersorger(IVerwaltung verwaltung) throws DUAInitialisierungsException {
        this.verwaltung = verwaltung;
        this.init();
    }

    protected abstract void init() throws DUAInitialisierungsException;

    public final IStandardAspekte getStandardPubInfos() {
        return this.standardAspekte;
    }

    protected IVerwaltung getVerwaltung() {
        return this.verwaltung;
    }

    protected void setStandardAspekte(IStandardAspekte standardAspekte) {
        this.standardAspekte = standardAspekte;
    }

    protected class StandardPublikationsZuordnung {
        private SystemObjectType typ;
        private AttributeGroup atg;
        private Aspect aspEingang;
        private Aspect aspAusgang;

        public StandardPublikationsZuordnung(String typ, String atg, String aspEingang, String aspAusgang) throws DUAInitialisierungsException {
            try {
                DataModel dataModel = StandardAspekteVersorger.this.verwaltung.getVerbindung().getDataModel();
                this.typ = dataModel.getType(typ);
                if (null == this.typ) {
                    throw new IllegalArgumentException("Typ '" + typ + "' ist nicht definiert");
                }
                this.atg = dataModel.getAttributeGroup(atg);
                if (null == this.atg) {
                    throw new IllegalArgumentException("Atg '" + atg + "' ist nicht definiert");
                }
                this.aspEingang = dataModel.getAspect(aspEingang);
                this.aspAusgang = dataModel.getAspect(aspAusgang);
            }
            catch (Exception ex) {
                throw new DUAInitialisierungsException("Standardpublikationsaspekt konnte nicht eingerichtet werden ", ex);
            }
        }
    }

    protected class StandardAspekteAdapter
    implements IStandardAspekte {
        private final Collection<DAVObjektAnmeldung> anmeldungenGlobal = new TreeSet<DAVObjektAnmeldung>();
        private final Map<DAVObjektAnmeldung, Aspect> publikationsMap = new TreeMap<DAVObjektAnmeldung, Aspect>();

        public StandardAspekteAdapter(StandardPublikationsZuordnung[] zuordnungen) throws DUAInitialisierungsException {
            if (zuordnungen != null) {
                for (StandardPublikationsZuordnung zuordnung : zuordnungen) {
                    try {
                        for (SystemObject finObj : DUAUtensilien.getBasisInstanzen((SystemObject)zuordnung.typ, StandardAspekteVersorger.this.verwaltung.getVerbindung(), StandardAspekteVersorger.this.verwaltung.getKonfigurationsBereiche())) {
                            this.anmeldungenGlobal.add(new DAVObjektAnmeldung(finObj, new DataDescription(zuordnung.atg, zuordnung.aspAusgang)));
                        }
                        DataDescription originalDesc = new DataDescription(zuordnung.atg, zuordnung.aspEingang);
                        for (SystemObject obj : zuordnung.typ.getElements()) {
                            if (!obj.isValid()) continue;
                            DAVObjektAnmeldung objektAnmeldung = new DAVObjektAnmeldung(obj, originalDesc);
                            this.publikationsMap.put(objektAnmeldung, zuordnung.aspAusgang);
                        }
                    }
                    catch (Exception e) {
                        throw new DUAInitialisierungsException("Standard-Publikaionsinformationen konnten nicht angelegt werden: " + e);
                    }
                }
            }
        }

        @Override
        public Aspect getStandardAspekt(ResultData originalDatum) {
            Aspect ergebnis = null;
            if (originalDatum != null) {
                try {
                    DAVObjektAnmeldung objektAnmeldung = new DAVObjektAnmeldung(originalDatum.getObject(), originalDatum.getDataDescription());
                    ergebnis = this.publikationsMap.get(objektAnmeldung);
                }
                catch (IllegalArgumentException e) {
                    Debug.getLogger().fine("Der Standard-Publikationsaspekt konntenicht ermittelt werden: " + originalDatum, (Throwable)e);
                }
            }
            return ergebnis;
        }

        @Override
        public final Collection<DAVObjektAnmeldung> getStandardAnmeldungen(SystemObject[] objektFilter) {
            TreeSet<DAVObjektAnmeldung> anmeldungen = new TreeSet();
            if (objektFilter == null || objektFilter.length <= 0) {
                anmeldungen = this.anmeldungenGlobal;
            } else {
                HashSet<SystemObject> objekte = new HashSet<SystemObject>();
                for (SystemObject obj : objektFilter) {
                    objekte.add(obj);
                }
                for (DAVObjektAnmeldung anmeldung : this.anmeldungenGlobal) {
                    if (!objekte.contains(anmeldung.getObjekt())) continue;
                    anmeldungen.add(anmeldung);
                }
            }
            return anmeldungen;
        }

        public String toString() {
            StringBuilder s = new StringBuilder("Objekt-Anmeldungen:\n");
            for (DAVObjektAnmeldung anmeldung : this.anmeldungenGlobal) {
                s.append(anmeldung);
            }
            return s.toString();
        }

        @Override
        public Collection<AttributeGroup> getAlleAttributGruppen() {
            TreeSet<AttributeGroup> attributGruppen = new TreeSet<AttributeGroup>();
            for (DAVObjektAnmeldung anmeldung : this.anmeldungenGlobal) {
                attributGruppen.add(anmeldung.getDatenBeschreibung().getAttributeGroup());
            }
            return attributGruppen;
        }
    }
}

