/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.adapter;

import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVSendeAnmeldungsVerwaltung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.DatenFlussSteuerungsVersorger;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IBearbeitungsKnoten;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IStandardAspekte;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import java.io.Serializable;

public abstract class AbstraktBearbeitungsKnotenAdapter
implements IBearbeitungsKnoten {
    protected IBearbeitungsKnoten knoten;
    protected boolean publizieren;
    protected IVerwaltung verwaltung;
    protected IStandardAspekte standardAspekte;
    protected DAVSendeAnmeldungsVerwaltung publikationsAnmeldungen;

    @Override
    public void setPublikation(boolean publizieren1) {
        this.publizieren = publizieren1;
    }

    @Override
    public void setNaechstenBearbeitungsKnoten(IBearbeitungsKnoten knoten1) {
        this.knoten = knoten1;
    }

    @Override
    public void initialisiere(IVerwaltung dieVerwaltung) throws DUAInitialisierungsException {
        if (dieVerwaltung == null || dieVerwaltung.getVerbindung() == null) {
            throw new DUAInitialisierungsException("Es konnte keine Verbindung zum Verwaltungsmodul (bzw. zum Datenverteiler) hergestellt werden");
        }
        this.verwaltung = dieVerwaltung;
        this.publikationsAnmeldungen = new DAVSendeAnmeldungsVerwaltung(this.verwaltung.getVerbindung(), SenderRole.source());
        DatenFlussSteuerungsVersorger.getInstanz(this.verwaltung).addListener(this);
    }

    public String toString() {
        return "Modul-Typ: " + (Serializable)(this.getModulTyp() != null ? this.getModulTyp() : "unbekannt") + " in SWE " + this.verwaltung.getSWETyp();
    }

    public IVerwaltung getVerwaltung() {
        return this.verwaltung;
    }

    public IBearbeitungsKnoten getKnoten() {
        return this.knoten;
    }

    public boolean isPublizieren() {
        return this.publizieren;
    }

    protected DAVSendeAnmeldungsVerwaltung getPublikationsAnmeldungen() {
        return this.publikationsAnmeldungen;
    }

    protected IStandardAspekte getStandardAspekte() {
        return this.standardAspekte;
    }

    protected void setStandardAspekte(IStandardAspekte standardAspekte) {
        this.standardAspekte = standardAspekte;
    }
}

