/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.adapter;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.config.ConfigurationArea;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.DatenFlussSteuerungsVersorger;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.commandLineArgs.ArgumentList;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;

public abstract class AbstraktVerwaltungsAdapter
implements IVerwaltung {
    protected SystemObject[] objekte;
    protected ClientDavInterface verbindung;
    protected ArrayList<String> komArgumente = new ArrayList();
    private Collection<ConfigurationArea> kBereiche = new HashSet<ConfigurationArea>();
    protected DatenFlussSteuerungsVersorger dfsHilfe;

    @Override
    public final Collection<ConfigurationArea> getKonfigurationsBereiche() {
        return this.kBereiche;
    }

    @Override
    public final SystemObject[] getSystemObjekte() {
        return this.objekte;
    }

    @Override
    public final ClientDavInterface getVerbindung() {
        return this.verbindung;
    }

    public void initialize(ClientDavInterface dieVerbindung) throws Exception {
        try {
            this.verbindung = dieVerbindung;
            if (this.komArgumente == null) {
                throw new DUAInitialisierungsException("Es wurden keine Kommandozeilenargumente \u00fcbergeben");
            }
            this.kBereiche = DUAUtensilien.getKonfigurationsBereicheAlsObjekte(this.verbindung, DUAUtensilien.getArgument("KonfigurationsBereichsPid", this.komArgumente));
            this.dfsHilfe = DatenFlussSteuerungsVersorger.getInstanz(this);
            this.initialisiere();
            Debug.getLogger().config(this.toString());
        }
        catch (DUAInitialisierungsException ex) {
            String fehler = "Initialisierung der Applikation " + this.getSWETyp().toString() + " fehlgeschlagen";
            Debug.getLogger().error(fehler, (Throwable)ex);
            ex.printStackTrace();
            if (this.verbindung != null) {
                this.verbindung.disconnect(true, fehler);
            }
            System.exit(0);
        }
    }

    public void parseArguments(ArgumentList argumente) throws Exception {
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            Debug.getLogger().error("Applikation wird wegen unerwartetem Fehler beendet", e);
            e.printStackTrace();
            Runtime.getRuntime().exit(-1);
        });
        for (String s : argumente.getArgumentStrings()) {
            if (s == null) continue;
            this.komArgumente.add(s);
        }
        argumente.fetchUnusedArguments();
    }

    public String toString() {
        String s = "SWE: " + this.getSWETyp() + "\n";
        Object dummy = "---keine Konfigurationsbereiche angegeben---\n";
        if (!this.kBereiche.isEmpty()) {
            dummy = "";
            for (ConfigurationArea kb : this.kBereiche) {
                dummy = (String)dummy + kb + "\n";
            }
        }
        return s + "Konfigurationsbereiche:\n" + (String)dummy;
    }

    @Override
    public String getArgument(String schluessel) {
        return DUAUtensilien.getArgument(schluessel, this.komArgumente);
    }

    protected abstract void initialisiere() throws DUAInitialisierungsException;

    protected ArrayList<String> getKomArgumente() {
        return this.komArgumente;
    }

    protected void clearKomArguments() {
        this.komArgumente.clear();
    }

    protected void addKomArgument(String argument) {
        this.komArgumente.add(argument);
    }

    protected void setSystemObjekte(Collection<SystemObject> newObjects) {
        this.objekte = newObjects.toArray(new SystemObject[newObjects.size()]);
    }
}

