/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.av;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVAnmeldungsVerwaltung;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import java.util.Collection;

public class DAVEmpfangsAnmeldungsVerwaltung
extends DAVAnmeldungsVerwaltung {
    private final ReceiverRole rolle;
    private final ReceiveOptions optionen;
    private final ClientReceiverInterface empfaenger;

    public DAVEmpfangsAnmeldungsVerwaltung(ClientDavInterface dav, ReceiverRole rolle, ReceiveOptions optionen, ClientReceiverInterface empfaenger) {
        super(dav);
        this.rolle = rolle;
        this.optionen = optionen;
        this.empfaenger = empfaenger;
    }

    @Override
    protected String abmelden(Collection<DAVObjektAnmeldung> abmeldungen) {
        String info = "";
        for (DAVObjektAnmeldung abmeldung : abmeldungen) {
            this.getDav().unsubscribeReceiver(this.empfaenger, abmeldung.getObjekt(), abmeldung.getDatenBeschreibung());
            this.removeAnmeldung(abmeldung);
        }
        return info;
    }

    @Override
    protected String anmelden(Collection<DAVObjektAnmeldung> anmeldungen) {
        String info = "";
        for (DAVObjektAnmeldung anmeldung : anmeldungen) {
            this.getDav().subscribeReceiver(this.empfaenger, anmeldung.getObjekt(), anmeldung.getDatenBeschreibung(), this.optionen, this.rolle);
            this.setAnmeldung(anmeldung, null);
        }
        return info;
    }

    @Override
    protected String getInfo() {
        return this.rolle + ", " + this.optionen;
    }
}

