/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.av;

import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import java.util.Objects;

public class DAVObjektAnmeldung
implements Comparable<DAVObjektAnmeldung> {
    private final SystemObject objekt;
    private final DataDescription datenBeschreibung;

    public DAVObjektAnmeldung(SystemObject objekt, DataDescription datenBeschreibung) {
        String fehler = DUAUtensilien.isKombinationOk(objekt, datenBeschreibung);
        if (fehler != null) {
            throw new IllegalArgumentException(fehler);
        }
        this.objekt = objekt;
        this.datenBeschreibung = datenBeschreibung;
    }

    public DAVObjektAnmeldung(ResultData resultat) {
        this(resultat.getObject(), resultat.getDataDescription());
    }

    public final DataDescription getDatenBeschreibung() {
        return this.datenBeschreibung;
    }

    public final SystemObject getObjekt() {
        return this.objekt;
    }

    @Override
    public int compareTo(DAVObjektAnmeldung that) {
        int result = Long.compare(this.getObjekt().getId(), that.getObjekt().getId());
        if (result == 0) {
            result = Long.compare(this.getDatenBeschreibung().getAttributeGroup().getId(), that.getDatenBeschreibung().getAttributeGroup().getId());
        }
        if (result == 0) {
            result = Long.compare(this.getDatenBeschreibung().getAspect().getId(), that.getDatenBeschreibung().getAspect().getId());
        }
        return result;
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof DAVObjektAnmeldung) {
            DAVObjektAnmeldung that = (DAVObjektAnmeldung)obj;
            result = this.getObjekt().equals(that.getObjekt()) && this.getDatenBeschreibung().getAttributeGroup().equals(that.getDatenBeschreibung().getAttributeGroup()) && this.getDatenBeschreibung().getAspect().equals(that.getDatenBeschreibung().getAspect());
        }
        return result;
    }

    public int hashCode() {
        return Objects.hash(this.datenBeschreibung, this.objekt);
    }

    public String toString() {
        return this.objekt + "\n" + this.datenBeschreibung + "\n";
    }
}

