/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.av;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientSenderInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.DataNotSubscribedException;
import de.bsvrz.dav.daf.main.OneSubscriptionPerSendData;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.SendSubscriptionNotConfirmed;
import de.bsvrz.dav.daf.main.SenderRole;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVAnmeldungsVerwaltung;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;

public class DAVSendeAnmeldungsVerwaltung
extends DAVAnmeldungsVerwaltung
implements ClientSenderInterface {
    private final SenderRole rolle;

    public DAVSendeAnmeldungsVerwaltung(ClientDavInterface dav, SenderRole rolle) {
        super(dav);
        this.rolle = rolle;
    }

    public final void sende(ResultData resultat) {
        try {
            DAVObjektAnmeldung anmeldung = new DAVObjektAnmeldung(resultat);
            DAVAnmeldungsVerwaltung.SendeStatus status = this.getAnmeldeStatus(anmeldung);
            if (status == null || status.getStatus() == 0) {
                boolean imMomentKeineDaten;
                boolean alsNaechstestKeineDaten;
                boolean bl = alsNaechstestKeineDaten = resultat.getData() == null;
                if (status != null) {
                    imMomentKeineDaten = status.isImMomentKeineDaten();
                    if (status.isImMomentKeineDaten() != alsNaechstestKeineDaten) {
                        this.setAnmeldung(anmeldung, new DAVAnmeldungsVerwaltung.SendeStatus(0, alsNaechstestKeineDaten));
                    }
                } else {
                    imMomentKeineDaten = true;
                    this.setAnmeldung(anmeldung, new DAVAnmeldungsVerwaltung.SendeStatus(0, alsNaechstestKeineDaten));
                }
                if (alsNaechstestKeineDaten && !imMomentKeineDaten || !alsNaechstestKeineDaten) {
                    this.getDav().sendData(resultat);
                }
            }
        }
        catch (DataNotSubscribedException | SendSubscriptionNotConfirmed e) {
            e.printStackTrace();
            Debug.getLogger().error("", e);
        }
    }

    @Override
    protected String abmelden(Collection<DAVObjektAnmeldung> abmeldungen) {
        String info = "";
        for (DAVObjektAnmeldung abmeldung : abmeldungen) {
            this.getDav().unsubscribeSender((ClientSenderInterface)this, abmeldung.getObjekt(), abmeldung.getDatenBeschreibung());
            this.removeAnmeldung(abmeldung);
        }
        return info;
    }

    @Override
    protected String anmelden(Collection<DAVObjektAnmeldung> anmeldungen) {
        String info = "";
        for (DAVObjektAnmeldung anmeldung : anmeldungen) {
            try {
                this.getDav().subscribeSender((ClientSenderInterface)this, anmeldung.getObjekt(), anmeldung.getDatenBeschreibung(), this.rolle);
                this.setAnmeldung(anmeldung, null);
            }
            catch (OneSubscriptionPerSendData e) {
                Debug.getLogger().error("Probleme beim Anmelden als Sender/Quelle:\n" + anmeldung, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return info;
    }

    public void dataRequest(SystemObject object, DataDescription dataDescription, byte state) {
        DAVObjektAnmeldung anmeldung = new DAVObjektAnmeldung(object, dataDescription);
        DAVAnmeldungsVerwaltung.SendeStatus status = this.getAnmeldeStatus(anmeldung);
        if (status == null || status.isImMomentKeineDaten()) {
            this.setAnmeldung(anmeldung, new DAVAnmeldungsVerwaltung.SendeStatus(state, true));
        } else {
            this.setAnmeldung(anmeldung, new DAVAnmeldungsVerwaltung.SendeStatus(state, false));
        }
    }

    public boolean isRequestSupported(SystemObject object, DataDescription dataDescription) {
        DAVObjektAnmeldung anmeldung = new DAVObjektAnmeldung(object, dataDescription);
        return this.isAngemeldet(anmeldung);
    }

    @Override
    protected String getInfo() {
        return this.rolle.toString();
    }
}

