/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.bm;

import de.bsvrz.dav.daf.main.ClientDavInterface;
import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.bm.IBmListener;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class BmClient
implements ClientReceiverInterface {
    private static BmClient instanz;
    private final Set<IBmListener> listeners = Collections.synchronizedSet(new HashSet());

    public static final BmClient getInstanz(ClientDavInterface dav) {
        if (instanz == null) {
            instanz = new BmClient(dav);
        }
        return instanz;
    }

    protected BmClient(ClientDavInterface dav) {
        DataDescription datenBeschreibung = new DataDescription(dav.getDataModel().getAttributeGroup("atg.betriebsMeldung"), dav.getDataModel().getAspect("asp.information"));
        dav.subscribeReceiver((ClientReceiverInterface)this, (SystemObject)dav.getDataModel().getConfigurationAuthority(), datenBeschreibung, ReceiveOptions.normal(), ReceiverRole.receiver());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(IBmListener listener) {
        Set<IBmListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(IBmListener listener) {
        Set<IBmListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] results) {
        if (results != null) {
            for (ResultData result : results) {
                if (result == null || result.getData() == null) continue;
                long zeit = result.getDataTime();
                String text = result.getData().getTextValue("MeldungsText").getText();
                SystemObject referenz = null;
                if (result.getData().getReferenceArray("Referenz") != null && result.getData().getReferenceArray("Referenz").getLength() > 0 && result.getData().getReferenceArray("Referenz").getReferenceValue(0) != null) {
                    referenz = result.getData().getReferenceArray("Referenz").getReferenceValue(0).getSystemObject();
                }
                Set<IBmListener> set = this.listeners;
                synchronized (set) {
                    for (IBmListener listener : this.listeners) {
                        listener.aktualisiereBetriebsMeldungen(referenz, zeit, text);
                    }
                }
            }
        }
    }
}

