/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.dfs;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.PublikationsZuordung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerungFuerModul;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class DatenFlussSteuerungFuerModul
implements IDatenFlussSteuerungFuerModul {
    private final Collection<PublikationsZuordung> publikationsZuordnungen = new ArrayList<PublikationsZuordung>();
    private final Map<PublikationObjAtg, PublikationFuerDatum> publikationsMap = new TreeMap<PublikationObjAtg, PublikationFuerDatum>();

    public final void add(PublikationsZuordung pz) {
        for (DAVObjektAnmeldung anmeldung : pz.getObjektAnmeldungen()) {
            PublikationObjAtg pubObjAtg = new PublikationObjAtg(anmeldung.getObjekt(), anmeldung.getDatenBeschreibung().getAttributeGroup());
            PublikationFuerDatum pub = new PublikationFuerDatum(pz.isPublizieren(), pz.getAspekt());
            this.publikationsMap.put(pubObjAtg, pub);
        }
        this.publikationsZuordnungen.add(pz);
    }

    @Override
    public Collection<DAVObjektAnmeldung> getDatenAnmeldungen(SystemObject[] filterObjekte, Collection<DAVObjektAnmeldung> standardAnmeldungen) {
        TreeSet<DAVObjektAnmeldung> alleAnmeldungen = new TreeSet<DAVObjektAnmeldung>();
        TreeSet<DAVObjektAnmeldung> stdAnmeldungen = new TreeSet<DAVObjektAnmeldung>();
        stdAnmeldungen.addAll(standardAnmeldungen);
        for (PublikationsZuordung pz : this.publikationsZuordnungen) {
            if (pz.isPublizieren()) {
                HashSet<SystemObject> pzAnzumeldendeObjekte = new HashSet<SystemObject>();
                if (filterObjekte != null && filterObjekte.length > 0) {
                    block1: for (SystemObject obj : pz.getObjekte()) {
                        for (SystemObject filterObj : filterObjekte) {
                            if (!obj.equals(filterObj)) continue;
                            pzAnzumeldendeObjekte.add(obj);
                            continue block1;
                        }
                    }
                } else {
                    pzAnzumeldendeObjekte.addAll(pz.getObjekte());
                }
                for (DAVObjektAnmeldung pzAnmeldung : pz.getObjektAnmeldungen()) {
                    if (!pzAnzumeldendeObjekte.contains(pzAnmeldung.getObjekt())) continue;
                    alleAnmeldungen.add(pzAnmeldung);
                }
                continue;
            }
            stdAnmeldungen.removeAll(pz.getObjektAnmeldungen());
        }
        alleAnmeldungen.addAll(stdAnmeldungen);
        return alleAnmeldungen;
    }

    @Override
    public final ResultData getPublikationsDatum(ResultData originalDatum, Data plausibilisiertesDatum, Aspect standardAspekt) {
        ResultData ergebnis = null;
        Aspect publikationsAspect = null;
        PublikationObjAtg pubObjAtg = new PublikationObjAtg(originalDatum.getObject(), originalDatum.getDataDescription().getAttributeGroup());
        PublikationFuerDatum pubDatum = this.publikationsMap.get(pubObjAtg);
        if (pubDatum != null) {
            if (pubDatum.publizieren) {
                publikationsAspect = pubDatum.asp;
            } else if (pubDatum.asp != standardAspekt) {
                publikationsAspect = standardAspekt;
            }
        } else {
            publikationsAspect = standardAspekt;
        }
        if (publikationsAspect != null) {
            DataDescription dd = new DataDescription(originalDatum.getDataDescription().getAttributeGroup(), publikationsAspect);
            ergebnis = new ResultData(originalDatum.getObject(), dd, originalDatum.getDataTime(), plausibilisiertesDatum);
        }
        return ergebnis;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("\nDatenflusssteuerung f\u00fcr Modul:\n");
        int i = 0;
        for (PublikationsZuordung pz : this.publikationsZuordnungen) {
            s.append("Publikationszuordnung: ").append(i++).append("\n").append(pz);
        }
        return s.toString();
    }

    protected class PublikationObjAtg
    implements Comparable<PublikationObjAtg> {
        private final SystemObject obj;
        private final AttributeGroup atg;

        protected PublikationObjAtg(SystemObject obj, AttributeGroup atg) {
            this.obj = obj;
            this.atg = atg;
        }

        @Override
        public int compareTo(PublikationObjAtg that) {
            int result = Long.compare(this.obj.getId(), that.obj.getId());
            if (result == 0) {
                result = Long.compare(this.atg.getId(), that.atg.getId());
            }
            return result;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.atg == null ? 0 : this.atg.hashCode());
            result = 31 * result + (this.obj == null ? 0 : this.obj.hashCode());
            return result;
        }

        private DatenFlussSteuerungFuerModul getOuterType() {
            return DatenFlussSteuerungFuerModul.this;
        }

        public boolean equals(Object obj1) {
            boolean result = false;
            if (obj1 instanceof PublikationObjAtg) {
                PublikationObjAtg that = (PublikationObjAtg)obj1;
                result = this.obj.equals(that.obj) && that.atg.equals(that.atg);
            }
            return result;
        }
    }

    protected class PublikationFuerDatum {
        private final boolean publizieren;
        private final Aspect asp;

        protected PublikationFuerDatum(boolean publizieren, Aspect asp) {
            this.asp = asp;
            this.publizieren = publizieren;
        }
    }
}

