/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.dfs;

import de.bsvrz.dav.daf.main.ClientReceiverInterface;
import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.ReceiveOptions;
import de.bsvrz.dav.daf.main.ReceiverRole;
import de.bsvrz.dav.daf.main.ResultData;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAInitialisierungsException;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.DatenFlussSteuerung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.ParameterSatz;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.PublikationsZuordung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.schnittstellen.IDatenFlussSteuerungsListener;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.SWETyp;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import de.bsvrz.sys.funclib.debug.Debug;
import java.util.Collection;
import java.util.HashSet;

public class DatenFlussSteuerungsVersorger
implements ClientReceiverInterface {
    private static final String STD_FEHLER = "Anmeldung auf Datenflusssteuerung fehlgeschlagen";
    private static DatenFlussSteuerungsVersorger instanz;
    private final Collection<IDatenFlussSteuerungsListener> listenerListe = new HashSet<IDatenFlussSteuerungsListener>();
    private DatenFlussSteuerung letzteDfs;
    private final IVerwaltung verwaltung;

    public static DatenFlussSteuerungsVersorger getInstanz(IVerwaltung verwaltung) throws DUAInitialisierungsException {
        if (instanz == null) {
            String dfsObjektStr = verwaltung.getArgument("dfs");
            SystemObject dfsObjekt = null;
            if (dfsObjektStr != null) {
                dfsObjekt = verwaltung.getVerbindung().getDataModel().getObject(dfsObjektStr);
            }
            instanz = new DatenFlussSteuerungsVersorger(verwaltung, dfsObjekt);
        }
        return instanz;
    }

    public static void reset() {
        instanz = null;
    }

    protected DatenFlussSteuerungsVersorger(IVerwaltung verwaltung, SystemObject dfsObjekt) throws DUAInitialisierungsException {
        if (verwaltung == null) {
            throw new DUAInitialisierungsException("Anmeldung auf Datenflusssteuerung fehlgeschlagen\nKeine Verbindung zum Datenverteiler");
        }
        this.verwaltung = verwaltung;
        if (dfsObjekt != null) {
            DataDescription dd = new DataDescription(verwaltung.getVerbindung().getDataModel().getAttributeGroup("atg.datenflussSteuerung"), verwaltung.getVerbindung().getDataModel().getAspect("asp.parameterSoll"));
            verwaltung.getVerbindung().subscribeReceiver((ClientReceiverInterface)this, dfsObjekt, dd, ReceiveOptions.normal(), ReceiverRole.receiver());
            Debug.getLogger().config("Fuer die Datenflusssteuerung wird das Objekt " + dfsObjekt + " verwendet.");
        } else {
            Debug.getLogger().info("Der Datenfluss ist nicht zur Laufzeit steuerbar.\nEs wurde kein Objekt vom Typ typ.datenflussSteuerung identifiziert.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(IDatenFlussSteuerungsListener listener) {
        Collection<IDatenFlussSteuerungsListener> collection = this.listenerListe;
        synchronized (collection) {
            this.listenerListe.add(listener);
            if (this.letzteDfs != null) {
                listener.aktualisierePublikation(this.letzteDfs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeListener(IDatenFlussSteuerungsListener listener) {
        if (listener != null) {
            Collection<IDatenFlussSteuerungsListener> collection = this.listenerListe;
            synchronized (collection) {
                this.listenerListe.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(ResultData[] resultate) {
        ResultData resultat;
        this.letzteDfs = new DatenFlussSteuerung();
        if (resultate != null && resultate.length > 0 && (resultat = resultate[resultate.length - 1]) != null && resultat.isSourceAvailable() && !resultat.isNoDataAvailable() && resultat.hasData() && resultat.getData() != null) {
            Data.Array ps = resultat.getData().getArray("ParameterSatz");
            for (int i = 0; i < ps.getLength(); ++i) {
                Data satz = ps.getItem(i);
                if (satz == null) continue;
                ParameterSatz dfParameterSatz = new ParameterSatz();
                SWETyp swe = SWETyp.getZustand((int)satz.getUnscaledValue("SWE").getState().getValue());
                dfParameterSatz.setSwe(swe);
                for (int j = 0; j < satz.getArray("PublikationsZuordnung").getLength(); ++j) {
                    Data paraZuordnung = satz.getArray("PublikationsZuordnung").getItem(j);
                    PublikationsZuordung dfParaZuordnung = new PublikationsZuordung(paraZuordnung, this.verwaltung);
                    dfParameterSatz.add(dfParaZuordnung);
                }
                ParameterSatz dummy = this.letzteDfs.getParameterSatzFuerSWE(swe);
                if (dummy != null) {
                    for (PublikationsZuordung neuePz : dfParameterSatz.getPubZuordnung()) {
                        dummy.add(neuePz);
                    }
                    continue;
                }
                this.letzteDfs.add(dfParameterSatz);
            }
        }
        if (this.letzteDfs != null) {
            Collection<IDatenFlussSteuerungsListener> collection = this.listenerListe;
            synchronized (collection) {
                for (IDatenFlussSteuerungsListener listener : this.listenerListe) {
                    listener.aktualisierePublikation(this.letzteDfs);
                }
            }
        }
    }
}

