/*
 * Decompiled with CFR 0.152.
 */
package de.bsvrz.sys.funclib.bitctrl.dua.dfs;

import de.bsvrz.dav.daf.main.Data;
import de.bsvrz.dav.daf.main.DataDescription;
import de.bsvrz.dav.daf.main.config.Aspect;
import de.bsvrz.dav.daf.main.config.AttributeGroup;
import de.bsvrz.dav.daf.main.config.SystemObject;
import de.bsvrz.sys.funclib.bitctrl.dua.DUAUtensilien;
import de.bsvrz.sys.funclib.bitctrl.dua.av.DAVObjektAnmeldung;
import de.bsvrz.sys.funclib.bitctrl.dua.dfs.typen.ModulTyp;
import de.bsvrz.sys.funclib.bitctrl.dua.schnittstellen.IVerwaltung;
import java.util.Collection;
import java.util.HashSet;
import java.util.TreeSet;

public class PublikationsZuordung {
    private final ModulTyp modulTyp;
    private final Aspect aspekt;
    private final Collection<SystemObject> objekte = new HashSet<SystemObject>();
    private final Collection<AttributeGroup> atgs = new HashSet<AttributeGroup>();
    private final boolean publizieren;
    private final Collection<DAVObjektAnmeldung> anmeldungen = new TreeSet<DAVObjektAnmeldung>();

    protected PublikationsZuordung(Data data, IVerwaltung verwaltung) {
        this.aspekt = (Aspect)data.getReferenceValue("PublikationsAspekt").getSystemObject();
        this.modulTyp = ModulTyp.getZustand((int)data.getUnscaledValue("ModulTyp").getState().getValue());
        this.publizieren = data.getTextValue("Publizieren").getText().toLowerCase().equals("ja");
        Data.ReferenceArray objArray = data.getReferenceArray("Objekt");
        if (objArray.getLength() == 0) {
            this.objekte.addAll(DUAUtensilien.getBasisInstanzen(null, verwaltung.getVerbindung(), verwaltung.getKonfigurationsBereiche()));
        } else {
            for (Data.ReferenceValue refVal : objArray.getReferenceValues()) {
                this.objekte.addAll(DUAUtensilien.getBasisInstanzen(refVal.getSystemObject(), verwaltung.getVerbindung(), verwaltung.getKonfigurationsBereiche()));
            }
        }
        Data.ReferenceArray atgArray = data.getReferenceArray("AttributGruppe");
        if (atgArray.getLength() == 0) {
            this.atgs.add(null);
        } else {
            for (Data.ReferenceValue refVal : atgArray.getReferenceValues()) {
                this.atgs.add((AttributeGroup)refVal.getSystemObject());
            }
        }
        for (AttributeGroup atg : this.atgs) {
            DataDescription datenBeschreibung = new DataDescription(atg, this.aspekt);
            for (SystemObject finObj : this.objekte) {
                this.anmeldungen.addAll(DUAUtensilien.getAlleObjektAnmeldungen(finObj, datenBeschreibung, verwaltung.getVerbindung()));
            }
        }
    }

    public Collection<DAVObjektAnmeldung> getObjektAnmeldungen() {
        return this.anmeldungen;
    }

    public Aspect getAspekt() {
        return this.aspekt;
    }

    public final ModulTyp getModulTyp() {
        return this.modulTyp;
    }

    public final boolean isPublizieren() {
        return this.publizieren;
    }

    public final Collection<AttributeGroup> getAtgs() {
        return this.atgs;
    }

    public final Collection<SystemObject> getObjekte() {
        return this.objekte;
    }

    public final String isKompatibelMit(PublikationsZuordung that) {
        if (this.modulTyp.equals(that.getModulTyp()) && this.isPublizieren() && that.isPublizieren() && !this.getAspekt().equals(that.getAspekt())) {
            for (DAVObjektAnmeldung thisAnmeldung : this.getObjektAnmeldungen()) {
                for (DAVObjektAnmeldung thatAnmeldung : that.getObjektAnmeldungen()) {
                    if (!thisAnmeldung.getObjekt().equals(thatAnmeldung.getObjekt()) || !thisAnmeldung.getDatenBeschreibung().getAttributeGroup().equals(thatAnmeldung.getDatenBeschreibung().getAttributeGroup())) continue;
                    return "Die beiden Objektanmeldungen sind f\u00fcr die Datenflusssteuerung widerspr\u00fcchlich:\n" + thisAnmeldung + "\n" + thatAnmeldung;
                }
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder s = new StringBuilder("Modul-Typ: ").append(this.modulTyp).append("\n");
        s.append("Aspekt: ").append(this.aspekt).append("\n");
        s.append("Publizieren: ").append(this.publizieren ? "ja" : "nein").append("\n");
        for (SystemObject obj : this.objekte) {
            s.append("Objekt: ").append(obj).append("\n");
        }
        for (AttributeGroup atg : this.atgs) {
            s.append("Atg: ").append(atg).append("\n");
        }
        return s.toString();
    }
}

